import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';
import { MapComponent } from '../components/mapComponent';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';

export default class GameScene extends Scene {
    public bg:eui.Group;
    public bg_ico:eui.Image;
    public mapGroup:eui.Group;
    public ruleBtn:eui.Button;
    public recordBtn:eui.Button;
    public showBtn:eui.Button;
    public lightBtn:eui.Button;
    public rankBtn:eui.Button;
    public light:eui.Image;
    public lightmask:eui.Image;
    
    private mdata:any;

    private rankExposure:any;
    private prizeExposure:any;
    private ruleExposure:any;
    private showExposure:any;


    public get skinKey() { return 'GameScene' }
    public get groupName() { return 'game_scene' }

    constructor(data?) {
        super(data);
        this.mdata = data;

    }

    initEvents() {
        // this.timer.addEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        this.lightBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_lightBtn,this);
        this.showBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_showBtn,this);
        this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_recordBtn,this);
        this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_rankBtn,this);
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_ruleBtn,this);

    }

    removeEvents() {
        super.removeEvents();
        // this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        // this.timer.removeEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.timer.stop();//停止倒计时
        this.lightBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_lightBtn,this);
        this.showBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_showBtn,this);
        this.recordBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_recordBtn,this);
        this.rankBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_rankBtn,this);
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_ruleBtn,this);

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
        // var mcJson = await RES.getResAsync('xinxingAct_json');
        // var mcImg = await RES.getResAsync('xinxingAct_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        //this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
       // this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }
    map
    private initUI(): void {
        let rankDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
        let rankDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.rankExposure = Buried.createExposure(rankDpmOut, rankDcmOut);
        NetManager.ins.showLog(this.rankExposure);
        
        let prizeDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let prizeDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.prizeExposure = Buried.createExposure(prizeDpmOut, prizeDcmOut);
        NetManager.ins.showLog(this.prizeExposure);
        
        let ruleDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
        let ruleDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.ruleExposure = Buried.createExposure(ruleDpmOut, ruleDcmOut);
        NetManager.ins.showLog(this.ruleExposure);
        

        this.map=new MapComponent();
        this.mapGroup.addChild(this.map);
        //中间地图信息待定（不是我做啦啦啦啦啦）
        
        PanelCtrl.instance.btnAni(this.lightBtn);
        PanelCtrl.instance.btnAni(this.showBtn);
        PanelCtrl.instance.btnAni(this.rankBtn);
        if(this.mdata){
            this.lightBtn.visible = false;
            this.showBtn.visible = true;
            let showDpmOut = Buried.connectDpm(110, 17, 1); // 点击埋点   
            let showDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            this.showExposure = Buried.createExposure(showDpmOut, showDcmOut);
            NetManager.ins.showLog(this.showExposure);
            this.lightmask.visible = false;
            this.light.visible= false;
        }else{
            this.lightBtn.visible = true;
            this.showBtn.visible = false;
            this.light.mask = this.lightmask;
            this.lightBtnAni();
            this.light.touchEnabled = false;
        }

    } 
    lightBtnAni(){
        egret.Tween.get(this.light,{loop:true})
        .set({x:-13})
        .to({x:550},1000)
    }

    onTap_lightBtn(){
        console.log("去点亮家乡");
        SceneCtrl.instance.change(ModuleTypes.CHOSE_SCENE);
    }
    onTap_showBtn(){
        console.log("去查看家乡");
        NetManager.ins.clickLog(this.showExposure);
        PanelCtrl.instance.btnDelay(this.showBtn)
        NetPromise.ins.queryMyJoin()
        .then(()=>{
            let data = DataManager.ins.getData(NetName.queryMyJoin).data;
            console.log("data")
            console.log(data)
            NetPromise.ins.joinInfo()
            .then(()=>{
                GDispatcher.dispatchEvent("showpoint", DataManager.ins.getData(NetName.joinInfo).data.adcode);
                NetPromise.ins.catchAdcode=DataManager.ins.getData(NetName.joinInfo).data.adcode;
            })
            .catch(()=>{

            })
          
            SceneCtrl.instance.change(ModuleTypes.SHARE_SCENE,data);
        })
        .catch(()=>{
            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL);
        })
    }
    onTap_rankBtn(){
        NetManager.ins.clickLog(this.rankExposure);
        PanelCtrl.instance.btnDelay(this.rankBtn);
        NetPromise.ins.joinInfo()
        .then(()=>{
            let mydata = DataManager.ins.getData(NetName.joinInfo).data;
            NetPromise.ins.rankingInfo()
            .then(()=>{
                let rankdata = DataManager.ins.getData(NetName.rankingInfo).data;
                let data = {mydata:mydata,rankdata:rankdata};
                PanelCtrl.instance.show(ModuleTypes.RANK_PANEL,data);
            })
            .catch(()=>{

            })
            
        })
        .catch(()=>{

        })
        
    }
    onTap_recordBtn(){
        NetManager.ins.clickLog(this.prizeExposure);
        window.location.href = window["prizeurl"];
    }
    onTap_ruleBtn(){
        NetManager.ins.clickLog(this.ruleExposure);
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        NetPromise.ins.projectRule()
        .then(()=>{
            console.log("规则弹窗");
            PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
        })
        .catch(()=>{
            PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
        })
        
    }
 
}