import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';
import { MapComponent } from '../components/mapComponent';

export default class GameScene extends Scene {
    public bg:eui.Group;
    public bg_ico:eui.Image;
    public mapGroup:eui.Group;
    public ruleBtn:eui.Button;
    public recordBtn:eui.Button;
    public showBtn:eui.Button;
    public lightBtn:eui.Button;
    public rankBtn:eui.Button;
    

    public get skinKey() { return 'GameScene' }
    public get groupName() { return 'game_scene' }

    constructor(data?) {
        super(data);
    }

    initEvents() {
        // this.timer.addEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);

    }

    removeEvents() {
        super.removeEvents();
        // this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        // this.timer.removeEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.timer.stop();//停止倒计时

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
        // var mcJson = await RES.getResAsync('xinxingAct_json');
        // var mcImg = await RES.getResAsync('xinxingAct_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        //this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
       // this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }
    map
    private initUI(): void {
        this.map=new MapComponent();
        this.mapGroup.addChild(this.map);
    } 
 
}