import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';

export default class GameScene extends Scene {
    public bg: eui.Image;
    public countDownBg: eui.Image;
    public bulletCountLb: eui.Label;
    public countDownLb: eui.Label;
    public passActGroup: eui.Group;
    public turnTableBg02: eui.Image;
    public turnTableBg00: eui.Image;
    public turnTableBg01: eui.Image;
    public shootBulletImg: eui.Image;
    public shootActGroup: eui.Group;
    public turnGroup: eui.Group;
    public bulletGroup: eui.Group;
    public bulletBoxGroup0: eui.Group;
    public bulletBoxGroup1: eui.Group;
    public bulletBoxGroup2: eui.Group;
    public bulletBoxGroup3: eui.Group;
    public bulletBoxGroup4: eui.Group;
    public bulletBoxGroup5: eui.Group;
    public bulletBoxGroup6: eui.Group;
    public bulletBoxGroup7: eui.Group;
    public bulletBoxGroup8: eui.Group;
    public bulletBoxGroup9: eui.Group;
    public bulletBoxGroup10: eui.Group;
    public bulletBoxGroup11: eui.Group;
    public bulletBoxGroup12: eui.Group;
    public bulletBoxGroup13: eui.Group;
    public bulletBoxGroup14: eui.Group;
    public bulletBoxGroup15: eui.Group;
    public bulletBoxGroup16: eui.Group;
    public bulletBoxGroup17: eui.Group;
    public bulletBoxGroup18: eui.Group;
    public bulletBoxGroup19: eui.Group;
    public bulletBoxGroup20: eui.Group;
    public bulletBoxGroup21: eui.Group;
    public bulletBoxGroup22: eui.Group;
    public bulletBoxGroup23: eui.Group;
    public bulletBoxGroup24: eui.Group;
    public bulletBoxGroup25: eui.Group;
    public bulletBoxGroup26: eui.Group;
    public bulletBoxGroup27: eui.Group;
    public bulletBoxGroup28: eui.Group;
    public bulletBoxGroup29: eui.Group;
    public bulletBoxGroup30: eui.Group;
    public bulletBoxGroup31: eui.Group;
    public bulletBoxGroup32: eui.Group;
    public turnTbBgImg: eui.Image;
    public goodActGroup: eui.Group;
    public goodActBg: eui.Image;
    public goodActHand: eui.Image;
    public clickGroup: eui.Group;
    public gkIconImg1: eui.Label;
    public gkIconImg2: eui.Label;
    public gkIconImg3: eui.Label;
    public goNextLevel: eui.Group;
    public levelTitleImg: eui.Image;
    public startBtn: eui.Button;


    private bEndY: number;
    private isOver: boolean;
    private bStartY: number;
    private isFail: boolean;
    private isRevived: boolean;
    private currLevel: number;
    private timeoutId: number;
    private canShoot: boolean;
    private timer: egret.Timer;
    private bulletCount: number;
    private timeDownNum: number;
    private levelCountArr: number[];
    private timeDownNumArr: number[];
    private gPlayModel: GamePlayModel;
    private xinxingAct: egret.MovieClip;
    private score: number = 1;

    private circleImg0: eui.Image;
    private circleImg1: eui.Image;
    private circleImg2: eui.Image;
    private circleImg3: eui.Image;
    private circleImg4: eui.Image;

    public get skinKey() { return 'GameScene' }
    public get groupName() { return 'game_scene' }

    constructor(data?) {
        super(data);
    }

    initEvents() {
        // this.timer.addEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);

    }

    removeEvents() {
        super.removeEvents();
        // this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        // this.timer.removeEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.timer.stop();//停止倒计时

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
        // var mcJson = await RES.getResAsync('xinxingAct_json');
        // var mcImg = await RES.getResAsync('xinxingAct_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        //this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }

    private initUI(): void {
      
    } 
 
}