import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../views/Panel";
import Loading from "../loading/Loading";
export default class PanelCtrl {
    private _parent: eui.UILayer;
    private _mask: egret.Shape;
    private msgPanel: Panel;
    public isLoadedMsg: boolean;
    public isLoseCoin: boolean;//是否submit前网络异常

    static _instance: PanelCtrl;
    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    init(parent: eui.UILayer) {
        this._parent = parent;
    }

    show(type: ModuleTypes, data?, hasMask: boolean = true) {
        if (type == ModuleTypes.MSG_PANEL) {//msg弹窗只弹一次
            if (this.msgPanel) {
                return;
            }
        }

        const cls = this._panelClassMap[type];

        Loading.instace.show();
        const panel: Panel = new cls(data, hasMask);
        this._current = panel;
        // panel.setSkinName();
        // panel.setMask();
        // panel.setShowAct();
        // panel.start(data);
        if (type == ModuleTypes.MSG_PANEL) {
            this.msgPanel = panel;
        }

        this.add(panel);

        this._parent.visible = true;
    }

    /**
     * 防止连点
     * @param targe 可交互对象
     * @param dtime 延时默认500ms
     */
    public btnDelay(targe: any, dtime: number = 500) {
        targe.touchEnabled = false;
        setTimeout(() => {
            targe.touchEnabled = true;
        }, dtime);
    }

    private add(panel: Panel) {
       /*  this._parent.$children.forEach((child) => {
            child['clearEvent']();
        }) */
        this._parent.removeChildren();
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
        // panel.addEventListener('onCreditsOut', this.onCreditsOut, this);
    }

    private remove(panel: Panel) {
        this._parent.removeChild(panel);
    }

    /**
     * 立即移除Panel
     * @param panel 
     */
    private removeImmediately(panel: Panel) {
        this._parent.removeChild(panel);
        this._parent.visible = false;
        this._current = null;
        // this.removeMaskImmediately();
    }

    private onPanelHide(e: egret.Event) {
        const panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        // panel.removeEventListener('onCreditsOut', this.onCreditsOut, this);
        this.remove(panel);

        if (this.msgPanel == panel) {
            this.msgPanel = null;
        }

        if (this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    }

    // private onCreditsOut(e: egret.Event){
    //     if(!window['CFG'] || !window['CFG'].appInfo) return;
    //     window.location.href = window['CFG'].appInfo.earnCreditsUrl;
    // }

    private _panelClassMap: any;
    registerPanelClass(name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    }


    private _current: Panel;

    closeCurrent() {
        if (this._current)
            this.remove(this._current);
    }

    //消息弹出框
    public showMsg(bname: string, titleIdx: number, titleY?: number, bgH?: number, callBack?: Function, closeCallBack?: Function, msg?: string, msg0?: string): void {
        var msgData: any = {
            msg: msg,
            msg0: msg0,
            titleY: titleY,
            bgH: bgH,
            btnName: bname,
            callBack: callBack ? callBack.bind(this) : null,
            closeCallBack: closeCallBack ? closeCallBack.bind(this) : null
        };
        msgData.titleIdx = titleIdx;

        PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, msgData);
    }
}