export class DogShowItemComponent extends eui.Component{
    public dogImgGroup:eui.Group;
    public lvLb:eui.Label;
    public dogNameLb:eui.Label;

    private lv:number;
    private dName:string;
    private size:number[];
    private iconName:string;

    private dImg:eui.Image;
    //点击收取回调
    private clickCallBack:Function;
    
    /**
     * 
     * @param lv 等级
     * @param name 狗名
     * @param iconName 资源名
     * @param callBack 
     */
    constructor(lv:number,name:string,iconName:string,size:number[],callBack:Function = null){
        super();
        this.skinName       = 'resource/skins/component/DogShowItemComponent.exml';
        this.clickCallBack  = callBack;

        this.lv = lv;
        this.size = size;
        this.dName = name;
        this.iconName = iconName;

        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private onSkinComplete():void{
        this.lvLb.text = 'LV.' + this.lv;
        this.dogNameLb.text = this.dName;
        this.dImg = new eui.Image();
        this.dImg.source = this.iconName;
        this.dogImgGroup.addChild(this.dImg);

        this.dImg.anchorOffsetX = this.size[0] * 0.5;
        this.dImg.anchorOffsetY = this.size[1] * 0.5;

        this.dImg.x = this.dogImgGroup.width * 0.5;
        this.dImg.y = this.dogImgGroup.height * 0.5;

        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);

    }

    public removeEvent():void{

    }

    private onClick():void{
        if(this.clickCallBack){
            this.clickCallBack(this);
        }
    }
    
    public playAct(start:number = 0):void{
        
    }

    public stopAct():void{
        // this.act.stop();
    }
}