import { LightComponent } from "./LightComponent";
import { NetPromise } from "../NetPromise";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import Loading from "../loading/Loading";

export class MapComponent extends eui.Component {

    public bg:eui.Image;
    public mapList:eui.Group;
    public z_650000:eui.Rect;
    public z_620000:eui.Rect;
    public z_630000:eui.Rect;
    public z_540000:eui.Rect;
    public z_510000:eui.Rect;
    public z_530000:eui.Rect;
    public z_520000:eui.Rect;
    public z_450000:eui.Rect;
    public z_440000:eui.Rect;
    public z_810000:eui.Rect;
    public z_820000:eui.Rect;
    public z_460000:eui.Rect;
    public z_710000:eui.Rect;
    public z_360000:eui.Rect;
    public z_350000:eui.Rect;
    public z_330000:eui.Rect;
    public z_310000:eui.Rect;
    public z_320000:eui.Rect;
    public z_370000:eui.Rect;
    public z_130000:eui.Rect;
    public z_120000:eui.Rect;
    public z_110000:eui.Rect;
    public z_210000:eui.Rect;
    public z_220000:eui.Rect;
    public z_230000:eui.Rect;
    public z_340000:eui.Rect;
    public z_430000:eui.Rect;
    public z_500000:eui.Rect;
    public z_610000:eui.Rect;
    public z_640000:eui.Rect;
    public z_150000:eui.Rect;
    public z_140000:eui.Rect;
    public z_410000:eui.Rect;
    public z_420000:eui.Rect;
    public pointBg:eui.Rect;
    



    //点击收取回调
    private clickCallBack: Function;

    /**
     * 
     */
    constructor(callBack: Function = null) {
        super();
        this.skinName = 'resource/skins/item/mapSkin.exml';
        this.clickCallBack = callBack;
        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);

        // GDispatcher.addEvent("showpoint",(adcodedata)=>{
        //     console.log("adcodedata")
        //     console.log(adcodedata)
        //     setTimeout((adcode)=>{
        //         localStorage.adcode=adcodedata.adcode
        //         this.showPoint()
        //     },2000)
        // },this)
        //alert("")
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    lightList=[]
    lightListData=[]

    showPoint(adcode){
        console.log("adcode")
        console.log(adcode+"")
        let parentAdcode=(adcode+"").slice(0,2)+"0000"
       this.pointBg.visible=true;
       this.LoadClip("https://yun.duiba.com.cn/db_games/activity/zxdljx/svga/doLight.svga")
       .then((lightStar)=>{
            this.lightStar=lightStar   
            this.lightStar.visible=true;
            console.log(`z_${parentAdcode}`)
            console.log(this[`z_${parentAdcode}`])
            this.lightStar.anchorOffsetX=300/2
            this.lightStar.anchorOffsetY=300/2
            this.lightStar.x=this[`z_${parentAdcode}`].x;
            this.lightStar.y=this[`z_${parentAdcode}`].y;  
            this.lightStar.startAniRange()
            let fun
            this.lightStar.addEventListener(egret.Event.COMPLETE, fun = () => {
                this.lightStar.removeEventListener(egret.Event.COMPLETE, fun, this)
                this.pointBg.visible=false;
               // this.lightStar.gotoAndStop(0, 1)
               // this.lightStar.visible=false;
            }, this)
       })
       .catch(()=>{
 
       })
       
    //   NetPromise.ins.lightStar.visible = true;
    //  NetPromise.ins.lightStar.gotoAndPlay(0, true)
    //   this.LoadClip("http://yun.duiba.com.cn/db_games/activity/zxdljx/svga/doLight.svga")
    //   .then((lightStar)=>{
    //     //lightStar["x"]=this[`z_${parentAdcode}`].x;
    //     //lightStar["y"]=this[`z_${parentAdcode}`].y;
    //   })
    //   .catch(()=>{

    //   })
    }


    LoadClip(url) {
        return new Promise((resolev, reject) => {
            var parser = new window["SVGA"].Parser();
            parser.load(url, (videoItem) => {
                let pet = new window["SVGA"].EgretMovieClip(videoItem);
                // pet.visible = false;
               // this.petBodyGroup.addChild(pet);
               this.addChild(pet)
                resolev(pet)
            }, (error) => {
                reject(error);
            })
        })
    }
    
    lightStar

    private onSkinComplete(): void {
       //if(!this.lightStar){
        // this.LoadClip("http://yun.duiba.com.cn/db_games/activity/zxdljx/svga/doLight.svga")
        // .then((lightStar)=>{
        //      this.lightStar=lightStar     
        // })
        // .catch(()=>{
  
        // })
       //}
        this.pointBg.visible=false;
        
        console.log(this.mapList)
        for(let i=0;i<this.mapList.$children.length;i++){
            this.mapList.$children[i].visible=false;
        }

        if(this.lightList){
            for(let i=0;i<this.lightList.length;i++){
                this.removeChild(this.lightList[i]);
            }
        }

        NetPromise.ins.mapInfo()
        .then(()=>{
            this.lightListData=DataManager.ins.getData(NetName.mapInfo).data;
            for(let i=0;i<this.lightListData.length;i++){
                //一共5个等级，50以内，50-100，100-500，500-2000，2000以上
                let lv=0
                if(this.lightListData[i].count>0&&this.lightListData[i].count<50){
                    lv=1
                }else if(this.lightListData[i].count>=50&&this.lightListData[i].count<100){
                    lv=2
                }else if(this.lightListData[i].count>=100&&this.lightListData[i].count<500){
                    lv=3
                }else if(this.lightListData[i].count>=500&&this.lightListData[i].count<2000){
                    lv=4
                }else if(this.lightListData[i].count>=2000){
                    lv=5
                }
                
                
                if(this.lightListData[i].adcode=="150000"){
                    this.lightList[i]=new LightComponent(lv,138,20,0,60);
                }else if(this.lightListData[i].adcode=="460000"){
                    this.lightList[i]=new LightComponent(lv,48,48,20,20);
                }else if(this.lightListData[i].adcode=="710000"){
                    this.lightList[i]=new LightComponent(lv,60,60,30,30);
                }else if(this.lightListData[i].adcode=="330000"){
                    this.lightList[i]=new LightComponent(lv,60,60,30,30);
                }else if(this.lightListData[i].adcode=="310000"){
                    this.lightList[i]=new LightComponent(lv,40,40,20,20);
                }else if(this.lightListData[i].adcode=="450000"){
                    this.lightList[i]=new LightComponent(lv,40,40,20,20);
                }else if(this.lightListData[i].adcode=="820000"){
                    this.lightList[i]=new LightComponent(lv,40,40,20,20);
                }else if(this.lightListData[i].adcode=="810000"){
                    this.lightList[i]=new LightComponent(lv,40,40,20,20);
                }else if(this.lightListData[i].adcode=="320000"){
                    this.lightList[i]=new LightComponent(lv,60,60,30,30);
                }else if(this.lightListData[i].adcode=="370000"){
                    this.lightList[i]=new LightComponent(lv,60,60,30,30);
                }else if(this.lightListData[i].adcode=="120000"){
                    this.lightList[i]=new LightComponent(lv,60,60,30,30);
                }else if(this.lightListData[i].adcode=="130000"){
                    this.lightList[i]=new LightComponent(lv,60,60,30,30);
                }else{
                    this.lightList[i]=new LightComponent(lv,60,60,30,30);
                }

                
                
                this.addChild(this.lightList[i]);
                this.lightList[i].x=this[`z_${this.lightListData[i].adcode}`].x+this.mapList.x;
                this.lightList[i].anchorOffsetX=this.lightList[i].width/2
                this.lightList[i].anchorOffsetY=this.lightList[i].width/2
                this.lightList[i].y=this[`z_${this.lightListData[i].adcode}`].y+this.mapList.y;
            }
            console.log(DataManager.ins.getData(NetName.mapInfo))
            this.addChild(this.pointBg)
            this.addChild(this.bg)
        })
        .catch(()=>{
           
        })

        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
    }

    public removeEvent(): void {

    }

    private onClick(): void {
        if (this.clickCallBack) {
            this.clickCallBack(this);
        }
    }

    public playAct(start: number = 0): void {

    }

    public stopAct(): void {
        // this.act.stop();
    }
}