import { LightComponent } from "./LightComponent";
import { NetPromise } from "../NetPromise";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import Loading from "../loading/Loading";

export class MapComponent extends eui.Component {

    public mapList: eui.Group;
    public z_650000: eui.Rect;
    public z_620000: eui.Rect;
    public z_630000: eui.Rect;
    public z_540000: eui.Rect;
    public z_510000: eui.Rect;
    public z_530000: eui.Rect;
    public z_520000: eui.Rect;
    public z_450000: eui.Rect;
    public z_440000: eui.Rect;
    public z_810000: eui.Rect;
    public z_820000: eui.Rect;
    public z_460000: eui.Rect;
    public z_710000: eui.Rect;
    public z_360000: eui.Rect;
    public z_350000: eui.Rect;
    public z_330000: eui.Rect;
    public z_310000: eui.Rect;
    public z_320000: eui.Rect;
    public z_370000: eui.Rect;
    public z_130000: eui.Rect;
    public z_120000: eui.Rect;
    public z_110000: eui.Rect;
    public z_210000: eui.Rect;
    public z_220000: eui.Rect;
    public z_230000: eui.Rect;
    public z_340000: eui.Rect;
    public z_430000: eui.Rect;
    public z_500000: eui.Rect;
    public z_610000: eui.Rect;
    public z_640000: eui.Rect;
    public z_150000: eui.Rect;
    public z_140000: eui.Rect;
    public z_410000: eui.Rect;
    public z_420000: eui.Rect;



    //点击收取回调
    private clickCallBack: Function;

    /**
     * 
     */
    constructor(callBack: Function = null) {
        super();
        this.skinName = 'resource/skins/item/mapSkin.exml';
        this.clickCallBack = callBack;
        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);

        GDispatcher.addEvent("showpoint",(adcode)=>{
            setTimeout(()=>{
                this.showPoint(adcode)
            },2000)
        },this)
        //alert("")
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    lightList=[]
    lightListData=[]

    showPoint(adcode){
        let parentAdcode=adcode.slice(0,2)+"0000"
        this.lightStar.x=this[`${parentAdcode}`].x;
        this.lightStar.y=this[`${parentAdcode}`].y;
        this.lightStar.visible = true;
        this.lightStar.gotoAndPlay(0, 1)
    }

    LoadClip(url) {
        return new Promise((resolev, reject) => {
            var parser = new window["SVGA"].Parser();
            Loading.instace.show()
            parser.load(url, (videoItem) => {
               let pet = new window["SVGA"].EgretMovieClip(videoItem);
               console.log("完成加载svga")
               console.log(pet)
               pet.visible = false;
               this.addChild(pet)
               Loading.instace.hide()
                resolev(pet)
            }, (error) => {
                Loading.instace.hide()
                reject(error);
            })
        })
    }

    lightStar

    private onSkinComplete(): void {
        this.lightStar=this.LoadClip("http://yun.duiba.com.cn/db_games/activity/zxdljx/svga/start.svga")
        
        console.log(this.mapList)
        for(let i=0;i<this.mapList.$children.length;i++){
            this.mapList.$children[i].visible=false;
        }

        if(this.lightList){
            for(let i=0;i<this.lightList.length;i++){
                this.removeChild(this.lightList[i]);
            }
        }

        NetPromise.ins.mapInfo()
        .then(()=>{
            this.lightListData=DataManager.ins.getData(NetName.mapInfo).data;
            for(let i=0;i<this.lightListData.length;i++){
                this.lightList[i]=new LightComponent();
                this.addChild(this.lightList[i]);
                this.lightList[i].x=this[`z_${this.lightListData[i].adcode}`].x+this.mapList.x;
                this.lightList[i].anchorOffsetX=this.lightList[i].width/2
                this.lightList[i].anchorOffsetY=this.lightList[i].width/2
                this.lightList[i].y=this[`z_${this.lightListData[i].adcode}`].y+this.mapList.y;
            }
            console.log(DataManager.ins.getData(NetName.mapInfo))
        })
        .catch(()=>{
           
        })

        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
    }

    public removeEvent(): void {

    }

    private onClick(): void {
        if (this.clickCallBack) {
            this.clickCallBack(this);
        }
    }

    public playAct(start: number = 0): void {

    }

    public stopAct(): void {
        // this.act.stop();
    }
}