export class LightComponent extends eui.Component{

    public image:eui.Image;

   
    //点击收取回调
    private clickCallBack:Function;
    
    /**
     * 
     */
    constructor(callBack:Function = null){
        super();
        this.skinName       = 'resource/skins/item/lightSkin.exml';
        this.clickCallBack  = callBack;
        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private onSkinComplete():void{
        this.image.visible=false;
        // setTimeout(()=>{
        //     this.image.visible=true;
        //     this["loop"].play(0)
        //     this["loop"].items.forEach((item) => {
        //         item.tween.loop = true;
        //     })
        // },1000*Math.random())
        this.setAnimate(this.image,2)
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
    }

    setAnimate(target,lv){
        var tw = egret.Tween.get( target, { loop:true} );
            tw.wait( 1000*Math.random() )
            .to( {scaleX:lv,scaleY:lv}, 1000 )
            .to( {scaleX:1,scaleY:1}, 1000 )
    }

    public removeEvent():void{

    }

    private onClick():void{
        if(this.clickCallBack){
            this.clickCallBack(this);
        }
    }
    
    public playAct(start:number = 0):void{
        
    }

    public stopAct():void{
        // this.act.stop();
    }
}