export class LightComponent extends eui.Component{

    public image:eui.Image;

   
    //点击收取回调
    private clickCallBack:Function;
    
    /**
     * 
     */
    constructor(callBack:Function = null){
        super();
        this.skinName       = 'resource/skins/item/lightSkin.exml';
        this.clickCallBack  = callBack;
        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private onSkinComplete():void{
        this.image.visible=false;
        setTimeout(()=>{
            this.image.visible=true;
            this["loop"].play(0)
            this["loop"].items.forEach((item) => {
                item.tween.loop = true;
            })
        },1000*Math.random())
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
    }

    public removeEvent():void{

    }

    private onClick():void{
        if(this.clickCallBack){
            this.clickCallBack(this);
        }
    }
    
    public playAct(start:number = 0):void{
        
    }

    public stopAct():void{
        // this.act.stop();
    }
}