import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';
import Panel from '../views/Panel';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';

export default class ChoseCityPanel extends Panel {

    public closeBtn:eui.Button;
    public thinkBtn:eui.Button;
    public sureBtn:eui.Button;

    private yesExposure:any;
    private noExposure:any;

    public adcodedata:any;
    public static instance:ChoseCityPanel;

    public get skinKey() { return 'ChoseCityPanel' }
    public get groupName() { return 'chose_panel' }

    constructor(data?) {
        super(data);
        ChoseCityPanel.instance = this;
    }

    initEvents() {
        // this.timer.addEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        this.thinkBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_thinkBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.sureBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_sureBtn, this);
    }

    removeEvents() {
        super.removeEvents();
        // this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        // this.timer.removeEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.timer.stop();//停止倒计时
        this.thinkBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_thinkBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.sureBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_sureBtn, this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
        // var mcJson = await RES.getResAsync('xinxingAct_json');
        // var mcImg = await RES.getResAsync('xinxingAct_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        //this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        this.adcodedata = data;
        // this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }

    private initUI(): void {
        let noDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
        let noDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.noExposure = Buried.createExposure(noDpmOut, noDcmOut);
        NetManager.ins.showLog(this.noExposure);
        
        let yesDpmOut = Buried.connectDpm(110, 9, 1); // 点击埋点   
        let yesDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.yesExposure = Buried.createExposure(yesDpmOut, yesDcmOut);
        NetManager.ins.showLog(this.yesExposure);

        PanelCtrl.instance.btnAni(this.thinkBtn);
        PanelCtrl.instance.btnAni(this.sureBtn);
    } 
 
    onTap_thinkBtn(){
        NetManager.ins.clickLog(this.noExposure);
        this.hidePanel();

    }
    onTap_closeBtn(){
        this.hidePanel();

    }
    ontap_sureBtn(){
        NetManager.ins.clickLog(this.yesExposure);
        PanelCtrl.instance.btnDelay(this.sureBtn);
        this.hidePanel();
        GDispatcher.dispatchEvent("showpoint", this.adcodedata);
        NetPromise.ins.choseCity(this.adcodedata.adcode)
            .then(()=>{
                SceneCtrl.instance.change(ModuleTypes.SHARE_SCENE);
            })
            .catch(()=>{
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL);
            })
        

    }
}