import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../views/Panel";
export default class PanelCtrl {
    private _parent: egret.Sprite;
    private _mask: egret.Shape;

    static _instance: PanelCtrl;
    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    init(parent: egret.Sprite) {
        this._parent = parent;
    }

    show(type: ModuleTypes, data?) {
        const cls = this._panelClassMap[type];
        const panel: Panel = new cls(data);
        this._current = panel;
        panel.start(data);
        this.add(panel);
    }

    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
        panel.addEventListener('onCreditsOut', this.onCreditsOut, this);
    }

    private remove(panel: Panel) {
        this._parent.removeChild(panel);
    }

    private onPanelHide(e: egret.Event) {
        const panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        panel.removeEventListener('onCreditsOut', this.onCreditsOut, this);
        this.remove(panel);
    }

    private onCreditsOut(e: egret.Event){
        if(!window['CFG'] || !window['CFG'].appInfo) return;
        if(window['CFG'].appInfo.earnCreditsUrl){
            window.location.href = window['CFG'].appInfo.earnCreditsUrl;
        }else{
            this.onPanelHide(e);
        }
    }

    private _panelClassMap: any;
    registerPanelClass(name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    }

    
    private _current: Panel;

    closeCurrent() {
        if (this._current)
            this.remove(this._current);
    }
}