
import {YtAssetsManager} from "../../libs/yt/index";
import {YtSceneManager} from "../../libs/yt/index";
import {YtParticleCon} from "../../libs/yt/index";

export class UseParticlee{
    private static instance: UseParticlee;

    public static get ins(): UseParticlee {
        if (!this.instance) {
            this.instance = new UseParticlee();
        }
        return this.instance;
    }

    private particleeExhaust;
    private particleeExhaust2;
    private particleBazi;
    private tailFlower;
    private tailFlower2;
    private tailFlower3;
    private pBoom;

    constructor(){
        this.init()
    }

    private scene=YtSceneManager.ins.scene;

    public init(){
        //尾气粒子
        this.particleeExhaust = new BABYLON.ParticleSystem("particles", 100, this.scene);
        //粒子的纹理
        this.particleeExhaust.particleTexture = YtAssetsManager.ins.resourceObject["textures"]["gameScene"]["flare"].clone();
        this.particleeExhaust.minEmitBox = new BABYLON.Vector3(0.1, 0.1, 0.1); // Starting all From
        this.particleeExhaust.maxEmitBox = new BABYLON.Vector3(-0.1, -0.1, -0.1); // Starting all From
        this.particleeExhaust.color1 = new BABYLON.Color4(0.7, 0.8, 1.0, 1.0);
        this.particleeExhaust.color2 = new BABYLON.Color4(0.2, 0.5, 1.0, 1.0);
        this.particleeExhaust.colorDead = new BABYLON.Color4(0, 0, 0, 0.5);
      //  particleeExhaust["addColorGradient"](0, new BABYLON.Color4(1, 1, 1, 0));
        this.particleeExhaust.minSize = 0.1;
        this.particleeExhaust.maxSize = 0.2;
        // console.log(particleSystem)
        this.particleeExhaust.minLifeTime = 5;
        this.particleeExhaust.maxLifeTime = 20;
        this.particleeExhaust.emitRate = 50;
        this.particleeExhaust.blendMode = BABYLON.ParticleSystem.BLENDMODE_ONEONE;
        this.particleeExhaust.direction1 = new BABYLON.Vector3(0, 0, 0);
        this.particleeExhaust.direction2 = new BABYLON.Vector3(0, 0, 0);
        // particleSystem2.direction2 = new BABYLON.Vector3(0, 100, 0);
        // Speed
        this.particleeExhaust.minEmitPower = 0.5;
        this.particleeExhaust.maxEmitPower = 0.5;
        this.particleeExhaust.updateSpeed = 1;
        this.particleeExhaust2=this.particleeExhaust["clone"]("s",1)
          
        this.tailFlower=new YtParticleCon(new BABYLON.Vector3(0,0,0),YtSceneManager.ins.scene, this.particleeExhaust);        
        //粒子尾气的位置
        this.tailFlower.Position(new BABYLON.Vector3(0, 0, 0))
        //设置粒子尾气的父级为玩家车辆
       // this.tailFlower.Parent(YtSceneManager.ins.scene.getMeshByName("boxPlayer"))


        
         //爆炸
         this.pBoom = new BABYLON.ParticleSystem("particles", 40, this.scene);
         this.pBoom.textureMask = new BABYLON.Color4(1, 1, 1 ,1.0);
 
         //粒子的纹理
         this.pBoom.particleTexture = YtAssetsManager.ins.resourceObject["textures"]["gameScene"]["flare2"].clone();
         this.pBoom.minEmitBox = new BABYLON.Vector3(0.3, 0.3, 0.3); // Starting all From
         this.pBoom.maxEmitBox = new BABYLON.Vector3(-0.3, -0.3, -0.3); // Starting all From
         this.pBoom.color1 = new BABYLON.Color4(1, 1, 1, 1);
         this.pBoom.color2 = new BABYLON.Color4(1, 1, 1, 1);
         this.pBoom.colorDead = new BABYLON.Color4(0, 0, 0, 0);
         this.pBoom.minSize = 0.2;
         this.pBoom.maxSize = 0.8;
         this.pBoom.gravity=new BABYLON.Vector3(0, -0.001, 0);
         // console.log(particleSystem)
         this.pBoom.minLifeTime = 50;
         this.pBoom.maxLifeTime = 100;
         this.pBoom.emitRate = 40;
         this.pBoom.blendMode = BABYLON.ParticleSystem.BLENDMODE_ONEONE;
         this.pBoom.direction1 = new BABYLON.Vector3(-0.01, -0.01, -0.01);
         this.pBoom.direction2 = new BABYLON.Vector3(0.01, 0.01, 0.01);
         //  particleeBoom.direction2 = new BABYLON.Vector3(-1, 0, 0);
         // particleSystem2.direction2 = new BABYLON.Vector3(0, 100, 0);
         // Speed
         this.pBoom.minEmitPower = 2;
         this.pBoom.maxEmitPower = 2;
         this.pBoom.updateSpeed = 2;

         this.tailFlower2=new YtParticleCon(new BABYLON.Vector3(0,0,0),YtSceneManager.ins.scene, this.pBoom);        
         //粒子尾气的位置
        
         //设置粒子尾气的父级为玩家车辆
        // this.tailFlower2.Parent(YtSceneManager.ins.scene.getMeshByName("boxPlayer"))



          //靶子破碎
          this.particleBazi = new BABYLON.ParticleSystem("particles", 40, this.scene);
          //粒子的纹理
          this.particleBazi.particleTexture = YtAssetsManager.ins.resourceObject["textures"]["gameScene"]["flare2"].clone();
          this.particleBazi.minEmitBox = new BABYLON.Vector3(0, 1, 1); // Starting all From
          this.particleBazi.maxEmitBox = new BABYLON.Vector3(0, -1,-1); // Starting all From
          this.particleBazi.color1 = new BABYLON.Color4(0.7, 0.8, 1.0, 1.0);
          this.particleBazi.color2 = new BABYLON.Color4(0.2, 0.5, 1.0, 1.0);
          this.particleBazi.colorDead = new BABYLON.Color4(0, 0, 0, 0.5);
          this.particleBazi.gravity=new BABYLON.Vector3(0, -0.001, 0);
        //  particleeExhaust["addColorGradient"](0, new BABYLON.Color4(1, 1, 1, 0));
          this.particleBazi.minSize = 0.05;
          this.particleBazi.maxSize = 0.8;
          // console.log(particleSystem)
          this.particleBazi.minLifeTime = 50;
          this.particleBazi.maxLifeTime = 100;
          this.particleBazi.emitRate = 50;
          this.particleBazi.blendMode = BABYLON.ParticleSystem.BLENDMODE_ONEONE;
          this.particleBazi.direction1 = new BABYLON.Vector3(-0.01, -0.01, -0.01);
          this.particleBazi.direction2 = new BABYLON.Vector3(0.01, 0.01, 0.01);
          // particleSystem2.direction2 = new BABYLON.Vector3(0, 100, 0);
          // Speed
          this.particleBazi.minEmitPower = 2;
          this.particleBazi.maxEmitPower = 2;
          this.particleBazi.updateSpeed = 2;
            
          this.tailFlower3=new YtParticleCon(new BABYLON.Vector3(0,0,0),YtSceneManager.ins.scene, this.particleBazi);        
          //粒子尾气的位置
          //this.tailFlower3.Position(new BABYLON.Vector3(0, 0, 0))

    }


    public start(){
        this.tailFlower.start()
    }

    public startBoom(mesh){
        this.tailFlower2.Position(mesh.position)
        this.tailFlower2.start()
    }

    public stopBoom(){
        this.tailFlower2.stop()
    }

    public startBazi(position,state){
        this.tailFlower3.Position(position)
        this.tailFlower3.start()
        if(state==1){
            this.particleBazi.color1 = new BABYLON.Color4(0.7, 0.8, 1.0, 1.0);
            this.particleBazi.color2 = new BABYLON.Color4(0.2, 0.5, 1.0, 1.0);
            this.particleBazi.colorDead = new BABYLON.Color4(0, 0, 0, 0.5);
            this.particleBazi.minEmitBox = new BABYLON.Vector3(0, 1, 1); // Starting all From
            this.particleBazi.maxEmitBox = new BABYLON.Vector3(0, -1,-1); // Starting all From
        }else if(state==0){
            this.particleBazi.color1 = new BABYLON.Color4(0, 1, 1.0, 1.0);
            this.particleBazi.color2 = new BABYLON.Color4(0, 1, 1.0, 1.0);
            this.particleBazi.colorDead = new BABYLON.Color4(0, 0, 0, 0.5);
            this.particleBazi.minEmitBox = new BABYLON.Vector3(0, 1, 1); // Starting all From
            this.particleBazi.maxEmitBox = new BABYLON.Vector3(0, -1,-1); // Starting all From
        }else{
            this.particleBazi.color1 = new BABYLON.Color4(0.7, 0.8, 1.0, 1.0);
            this.particleBazi.color2 = new BABYLON.Color4(0.2, 0.5, 1.0, 1.0);
            this.particleBazi.colorDead = new BABYLON.Color4(0, 0, 0, 0.5);
            this.particleBazi.minEmitBox = new BABYLON.Vector3(0, 3, 1); // Starting all From
            this.particleBazi.maxEmitBox = new BABYLON.Vector3(0, -3,-1); // Starting all From
        }
       
    }

    public stopBazi(){
        this.tailFlower3.stop()
    }


    public stop(){
        this.tailFlower.stop()
    }

    public Position(mesh){
        this.tailFlower.Position(mesh.position)
    }

    public setPSize(minSize,maxSize){
        this.particleeExhaust.minSize = minSize;
        this.particleeExhaust.maxSize = maxSize;
    }

}