import {YtModule} from "./YtModule";
import {YtDisplayPool} from "../others/YtDisplayPool";
import {YtModuleName} from "../enum/YtModuleName";
/**
 *Created by cuiliqiang on 2018/3/13
 * 等待面板
 */
export class YtWaitingModule extends YtModule {
        /**
        * 最大进度值
        */
       protected maxProgress: number;
   
       constructor(){
           super()
       }

        /**
         * 更新页面
         * @param {string} msgTxt 提示信息
         */
        public updateData(msgTxt: string, ...args): void {
            this.updateMsgTxt(msgTxt);
        }

        /**
         * 更新提示文案
         * @param desc 
         */
        protected updateMsgTxt(msgTxt: string): void {
            if (this.view.msgTxt) {
                this.view.msgTxt.text = msgTxt;
            }
        }
   
   
       public init(){
            YtDisplayPool.ins.displayPool[YtModuleName.WAITING_PANEL]=this;
       }
}