import { GDispatcher } from "duiba-tc";
import { YtModule } from "./YtModule";
import {YtGuiManager} from "../manager/YtGuiManager";

export class YtPanelModule extends YtModule {
    /**
     * 点击关闭按钮
     */
    public static CLOSE_BTN_CLICK = 'closeBtnClick';

    /**
     * 点击确定按钮
     */
    public static SURE_BTN_CLICK = 'sureBtnClick';

    /**
     * 点击取消按钮
     */
    public static CANCEL_BTN_CLICK = 'cancelBtnClick';

    public updateData(...args): void {

    }

    protected addEvent(): void {
        super.addEvent();
        if (this.view.closeBtn) {
            this.addClick(this.view.closeBtn, this.onClick_closeBtn);
        }
    }

     /**
     * 显示
     */
    protected show(...args): void {
        this.addEvent();
        this.updateData(...args)
        this.panelsAn.show(this.view.view,()=>{
            this.onOpen()
        },()=>{
            this.onOpened()
        })
    }

    /**
     * 隐藏
     */
    protected hide(): void {
        this.removeEvent();
        this.panelsAn.hide(this.view.view,()=>{
            this.onClose()
        },()=>{
            this.onClosed()
        })
    }

       /**
     * 打开前
     * */
    protected onOpen(...args): void{
        YtGuiManager.ins.appendGui(this.parent);
    }


    /**
     * 打开后
     * */
    protected onOpened(...args): void{

    }

    
    /**
     * 关闭前
     * */
    protected onClose(){

    }

    /**
     * 关闭后
     * */
    protected onClosed(){
        this.removeEvent()
        YtGuiManager.ins.removeGui(this.parent);
    }

    protected onClick_closeBtn(e): void {
        GDispatcher.dispatchEvent(YtPanelModule.CLOSE_BTN_CLICK, "closeBtn");
        this.removeEvent()
        YtGuiManager.ins.removeGui(this.parent);
    }

    protected removeEvent(): void {
        super.removeEvent();
        if (this.view.closeBtn) {
           // this.removeClick(this.view.closeBtn);
        }
    }
}