import {YtPanelModule} from "./YtPanelModule";
import {YtDisplayPool} from "../others/YtDisplayPool";
import {YtModuleName} from "../enum/YtModuleName";
import { YtIMsgData } from '../interface/YtIMsgData';

export class YtMsgModule extends YtPanelModule {

    constructor(){
        super()
    }

    public init(){
        YtDisplayPool.ins.displayPool[YtModuleName.MSG_PANEL]=this;
    }

    /**
     * 添加事件
     * */
    protected addEvent(){
        if(this.view.closeBtn){
            this.doEvents["closeBtn"]=this.addClick(this.view.closeBtn,this.onClick_closeBtn.bind(this))
        }
    }


    protected onClick_closeBtn():void{
        this.enableMouseEvt(false)
        this.hide();
    }


    protected removeEvent(){
        this.enableMouseEvt(true)
        if(this.view.closeBtn){
            this.view.closeBtn.onPointerUpObservable.remove(this.doEvents["closeBtn"])
        }
    }


     /**
     * 更新提示文案
     */
    protected updateMsgTxt(msgTxt: string): void {
        if (this.view.msgTxt) {
            this.view.msgTxt.text = msgTxt;
        }
    }

    /**
     * 更新确定按钮文案
     */
    protected updateSureBtnTxt(btnTxt: string): void {
        if (this.view.sureBtn) {
            this.view.sureBtn.children[0].text = btnTxt;
        }
    }

    /**
     * 更新取消按钮文案
     */
    protected updateCancelBtnTxt(btnTxt: string): void {
        if (this.view.cancelBtn) {
            this.view.cancelBtn.children[0].text = btnTxt;
        }
    }

    /**
     * 更新页面
     * @param args
     */
    public updateData(msgData: YtIMsgData, ...args): void {
        if(msgData.msg){
            this.updateMsgTxt(msgData.msg);
        }
        if(msgData.sureBtnTxt){
            this.updateSureBtnTxt(msgData.sureBtnTxt);
        }
        if(msgData.cancelBtnTxt){
            this.updateCancelBtnTxt(msgData.cancelBtnTxt);
        }
    }
}