
import {YtAnimationGui} from "../others/YtAnimationGui";
import {YtSceneManager} from "../manager/YtSceneManager";
import {YtGuiCreate} from "../others/YtGuiCreate";
import { YtLang } from '../util/YtLang';
/**
 *Created by cuiliqiang on 2018/3/1
 * 组件基类
 */
import {YtGuiManager} from "../manager/YtGuiManager";

export class YtModule {



    private timeoutId;

    protected view:any;

    protected parent:any;

     //事件
     protected doEvents=[];

       //面板隐藏显示实例
    protected panelsAn=new YtAnimationGui(YtSceneManager.ins.scene,YtGuiManager.ins.fullscreenUI)

      //规则元素
      protected section: any;

    /**
     * 显示对象（皮肤）
     */
    protected display: any;
    /**
     * 是否初始化完成
     */
    protected isInit: boolean;
    /**
     * 点击事件回调池
     */
    private clickCallbackBindPool: any;

    constructor() {
        this.initModel();
        this.clickCallbackBindPool = {};
      //  var skinClass: any = eval(this.module.skinName);
       // this.display = new skinClass();
       // this.clickCallbackPool = {};
    }

      /**
     * 初始化数据
     */
    protected initModel(): void {

    }

    /**
     * 初始化UI
     */
    protected initUI(): void {

    }

 /**
        * 显示
        */
    protected show(...args): void {
        this.removeEvent();
        this.updateData(...args)
        this.addEvent();
        YtGuiManager.ins.changeGui(this.parent);
    }

   /**
    * 隐藏
    */
   protected hide(): void {
       this.removeEvent();
       YtGuiManager.ins.removeGui(this.parent);
   }


    /**
     * 添加事件
     */
    protected addEvent(): void {

    }

    /**
     * 移除事件
     */
    protected removeEvent(): void {

    }

    /**
     * 更新页面
     * @param args
     */
    public updateData(...args): void {
        if (!this.isInit) {
            this.initUI();
            this.isInit = true;
        }
    }

    /**
     * 添加点击事件
     * @param display
     *
     * @param callback
     */
    protected addClick(display: any, callback: Function) {
        this.doEvents[display.name] = display.onPointerUpObservable.add(callback);
    }

    /**
     * 移除点击事件
     * @param display
     * @param callback
     */
    protected removeClick(display: any): void {
        display.onPointerUpObservable.remove(this.doEvents[display.name]);
    }

    /**
     * 延时启用点击事件
     * @param display 显示对象
     * @param {number} delay 延时事件
     */
    protected delayEnable(display: any, delay?: number): void {
        display.mouseEnable = display.mouseChildren = false;
        //如果已经禁用事件重新计算
        if (this.timeoutId) {
            clearTimeout(this.timeoutId);
        }

        this.timeoutId = setTimeout(function () {
            this.timeoutId = 0;
            display.mouseEnable = display.mouseChildren = true;
        }, delay ? delay : 500);
    }

     //dom模板
     protected viewNode;

     //页面HTML模板
     protected listTemplateHtml(data,config){

     }

    //html页面对象
    protected htmlView;

    protected htmlCreate(config,data){
        this.listTemplateHtml(data,config)
        document.body.appendChild(this.viewNode);
        YtGuiCreate.ins.preventDefault(this.viewNode)
    }

   

    public dispose(): void {

    }

      /**
     * 鼠标事件
     * @param enable 
     */
    protected enableMouseEvt(enable: boolean): void {
        let viewList
        for(viewList in this.view){
           // console.log(viewList)
           if(this.view[viewList]["mouseEnable"]==1||this.view[viewList]["mouseEnable"]==undefined){
              this.view[viewList].isHitTestVisible=enable;
           }
        }
    }


      /**
     * 单个元件鼠标事件
     * @param enable 
     */
    protected enableMouseEvtView(view:BABYLON.GUI.Control,enable: boolean): void {
        view.isHitTestVisible=enable;
        if(enable==true){
            view["mouseEnable"]=1;
        }else{
            view["mouseEnable"]=2;
        }
    }
}