
import {YtModule} from "./YtModule";
import {YtDisplayPool} from "../others/YtDisplayPool";
import {YtModuleName} from "../enum/YtModuleName";


export class YtLoadingModule extends YtModule {
 
     /**
     * 最大进度值
     */
    protected maxProgress: number;

    constructor(){
        super()
    }

    public init(){
        YtDisplayPool.ins.displayPool[YtModuleName.LOADING_GUI]=this;
    }


    /**
     *  更新页面
     * @param {number} max 最大进度值
     */
    public updateData(max: number): void {
        this.maxProgress = max;
    }

    public onProgress(curr: number): void {
        const pre: number = parseInt((curr*100).toString()) ;
        if (this.view.progressTxt) {
            this.view.progressTxt.text = pre + '%';
        }
    }
}