
export class YtSceneManager{

    public stage;
    public scene:BABYLON.Scene;
    public canvas:any=document.querySelector("#renderCanvas");
    public canvas2:any=document.getElementById("_a2x_canvas");
    public engine=new BABYLON.Engine(this.canvas, true, {
        deterministicLockstep: true,
        lockstepMaxSteps: 2
    });;

    private static instance: YtSceneManager;

    public static get ins(): YtSceneManager {
        if (!this.instance) {
            this.instance = new YtSceneManager();
        }
        return this.instance;
    }

    constructor(){
        this.init()
    }

    public init(){
        this.engine.getRenderingCanvas=()=>{
            return this.canvas2;
        };
        this.scene = this.createScene();
        this.engine.runRenderLoop(()=>{
            this.scene.render();
            TWEEN.update();
        });
        window.addEventListener("resize", ()=> {
            this.engine.resize();
        });
    }
    public createScene(){
        var scene = new BABYLON.Scene(this.engine);
        var n = scene._onPointerUp
            , o = scene._onPointerDown
            , r = scene._onPointerMove
            , a = BABYLON.Tools.GetPointerPrefix();
            this.canvas.removeEventListener(a + "move", r),
            this.canvas.removeEventListener(a + "down", o),
            window.removeEventListener(a + "up", n),
            scene._onPointerUp = (e)=>{
                void 0 !== e.pointerId && n(e)
            }
            ,
            scene._onPointerDown = (e)=> {
                void 0 !== e.pointerId && o(e)
            }
            ,
            scene._onPointerMove = (e)=> {
                void 0 !== e.pointerId && r(e)
            }
            ,
            this.canvas.addEventListener(a + "move", scene._onPointerMove, !1),
            this.canvas.addEventListener(a + "down", scene._onPointerDown, !1),
            window.addEventListener(a + "up", scene._onPointerUp, !1);
        //下面的代码是为了设置微信上面的touch事件兼容
        var camera = new BABYLON.FreeCamera("baseCamera", new BABYLON.Vector3(0, 0, 0), scene);
        return scene;
    }

   /* public get stage(): any {
        return this._stage;
    }*/

  /*   public get scene(): BABYLON.Scene {
        return this._scene;
    }

    public get canvas(): any {
        return this._canvas;
    }

    public get engine(): any {
        return this._engine;
    } */

    public change(display){
       /* console.log(display)
        var i;
        for(i in display){
            console.log(display[i])
        }*/

       /*  for(var l of SceneManager.ins.scene.meshes){
            l.dispose()
        } */

       // YtSceneManager.ins.scene.meshes=[]

        /*var j;
        for(j in SceneManager.ins.stage){
            console.log(SceneManager.ins.stage[j])
            if( SceneManager.ins.stage[j]){
                if(SceneManager.ins.stage[j].getChildMeshes){
                    SceneManager.ins.stage[j].getChildMeshes(false,(child)=>{
                        child.dispose();
                    });
                }
                if( SceneManager.ins.stage[j].dispose){
                    SceneManager.ins.stage[j].dispose()
                }
            }
        }*/
       // YtSceneManager.ins.stage=display;
    }

  /*  public change(module){
      //  console.log(this._stage._children)
        if(this.stage._children){
            this.stage._children.forEach(function (child) {
                this.stage.removeChild(child)
                child.dispose()
            }.bind(this))
        }
        this.stage.addChild(module)
      //  console.log( this._scene)
    }*/
}