
/**
 *Created by renjianfeng on 2018/2/28
 */
import {YtDisplayPool} from "../others/YtDisplayPool";
import {YtLang} from "../util/YtLang";
import { YtIMsgData } from '../interface/YtIMsgData';
import { IModuleData, GConsole, ModuleType, GFun, GDispatcher, ABNetManager } from "duiba-tc";
import {YtModuleName} from "../enum/YtModuleName";

export class YtModuleManager {

    //管理器单例
    private static instance: YtModuleManager;

    public static get ins(): YtModuleManager {
        if (!this.instance) {
            this.instance = new YtModuleManager();
        }
        return this.instance;
    }

    /**
     * 模块列表
     */
    private moduleList: IModuleData[] = [];

    /**
     * 打开一个模块
     * @param {ModuleName} moduleName
     */
    public openModule(moduleName:string, ...args): void {
        console.log(moduleName)
        console.log( YtDisplayPool.ins.displayPool[moduleName])
        YtDisplayPool.ins.displayPool[moduleName].show(...args)
    }


    /**
     * 按模块名获取模块数据
     * @param {string} moduleName 模块名
     * @returns {ModuleData}
     */
    public getModule(moduleName: string) {
        if(YtDisplayPool.ins.displayPool[moduleName]){
            return moduleName
        }else{
            return false;
        }
        //return this.moduleList[moduleName];
    }

     /**
     * 关闭一个模块
     * @param {ModuleName} moduleName
     */
    public closeModule(moduleName:string, ...args): void {
        console.log(moduleName)
        console.log( YtDisplayPool.ins.displayPool[moduleName])
        YtDisplayPool.ins.displayPool[moduleName].hide(...args)
    }


    /**
     * 提示模块
     */
    private msgModule: IModuleData;


    /**
     * 初始化
     */
    public init(): void {
        GDispatcher.addEvent(ABNetManager.ERROR, (msg: string) => {
           // alert()
           console.log("msg")
            const msgData: YtIMsgData = {
                msg: msg,
                sureBtnTxt: YtLang.lang_011,
                cancelBtnTxt: YtLang.lang_012
            };
            console.log(msgData)
            this.openMsgModule(msgData);
        }, this);
    }

     /**
     * 打开提示模块 
     * @param msgData 
     */
    public openMsgModule(msgData: YtIMsgData): void {
        this.openModule(YtModuleName.MSG_PANEL,msgData);
    }
}