import {YtModule} from "duiba-yt";
import {YtDisplayPool} from "duiba-yt";
import { GameWinnerModel, TwFun } from "duiba-tw";
import { SlModuleName } from "../../enum/SlModuleName";
import {YtModuleManager} from "duiba-yt";

/**
 *Created by cuiliqiang on 2018/3/16
 * 游戏结束场景
 */
export class SlGameWinnerModule extends YtModule {

    public init(){
        YtDisplayPool.ins.displayPool[SlModuleName.GAME_WINNER_GUI]=this;
    }

  /**
     * 数据
     */
    protected model: GameWinnerModel;

    protected initModel(): void {
        this.model = new GameWinnerModel();
    }

    public updateData(...args): void {
        this.updateRankTxt();
        this.updateOptionTxt();
        this.updateCidTxt();
    }

    /**
     * 更新排行榜文案
     */
    protected updateRankTxt(): void {
        if(this.view.rankTxt) {
            this.view.rankTxt.text = this.model.getRankTxt();
        }
    }

    /**
     * 更新奖品文案
     */
    protected updateOptionTxt(): void {
        if(this.view.optionTxt) {
            this.view.optionTxt.text = this.model.getOptionTxt();
        }
    }

    /**
     * 更新用户ID文案
     */
    protected updateCidTxt(): void {
        if(this.view.cidTxt) {
            this.view.cidTxt.text = this.model.getConsumerTxt();
        }
    }

    protected addEvent(): void {
        //兑换记录
        if (this.view.recordBtn) {
            this.addClick(this.view.recordBtn, this.onClick_recordBtn.bind(this));
        }

        //活动规则
        if (this.view.ruleBtn) {
            this.addClick(this.view.ruleBtn, this.onClick_ruleBtn.bind(this));
        }

        //活动奖品
        if (this.view.optionBtn) {
            this.addClick(this.view.optionBtn, this.onClick_optionBtn.bind(this));
        }

        //排行榜
        if (this.view.rankBtn) {
            this.addClick(this.view.rankBtn, this.onClick_rankBtn.bind(this));
        }
    }

    protected onClick_recordBtn(e): void {
        this.enableMouseEvt(false);
        window.location.href = TwFun.getRecordUrl('00');
    }

    protected onClick_ruleBtn(e): void {
        this.enableMouseEvt(false);
        this.model.getRule(this.getRule_result.bind(this));
    }

    protected getRule_result(success: boolean): void {
        this.enableMouseEvt(true);
        if(!success) {
            return;
        }
        YtModuleManager.ins.openModule(SlModuleName.RULE_PANEL);
    }

    protected onClick_optionBtn(e): void {
        this.enableMouseEvt(false);
        this.model.getOptions(this.getOptions_result.bind(this));
    }

    protected getOptions_result(success: boolean): void {
        this.enableMouseEvt(true);
        if(!success) {
            return;
        }
        YtModuleManager.ins.openModule(SlModuleName.GAME_OPTION_PANEL);
    }

    protected onClick_rankBtn(e): void {
       // this.delayEnable(this.view.rankBtn, 2000);
       // this.enableMouseEvt(false);
       YtModuleManager.ins.openModule(SlModuleName.GAME_END_RANK_PANEL, this.model.rankList);
    }

    protected removeEvent(): void {
        if (this.view.recordBtn) {
            this.removeClick(this.view.recordBtn);
        }

        if (this.view.ruleBtn) {
            this.removeClick(this.view.ruleBtn);
        }

        if (this.view.optionBtn) {
            this.removeClick(this.view.optionBtn);
        }

        if (this.view.rankBtn) {
            this.removeClick(this.view.rankBtn);
        }
    }
}