import {YtPanelModule} from "duiba-yt";
import {YtDisplayPool} from "duiba-yt";
import {YtModuleManager} from "duiba-yt";
import {SlModuleName} from "../../enum/SlModuleName";
import { GameWinModel } from 'duiba-tw';
export class SlGameWinModule extends YtPanelModule {

    //分数
    protected score;

    constructor(){
        super()
    }
     /**
     * 数据
     */
    protected model: GameWinModel;

    protected initModel(): void {
        this.model = new GameWinModel();
    }

     /**
     * 更新剩余次数文案
     */
    protected updateCountTxt(): void {
        if (this.view.costTxt) {
            this.view.costTxt = this.model.costTxt;
        }
    }

    /**
     * 更新排行文案
     */
    protected updateRankTxt(): void {
        if (this.view.rankTxt) {
            this.view.rankTxt.text = this.model.getRankTxt();
        }
    }

    /**
     * 更新当前积分文案
     */
    protected updateCurrScoreTxt(): void {
        if (this.view.currScoreTxt) {
            this.view.currScoreTxt.text = this.model.getCurrScoreTxt("{0}");
        }
    }

    /**
     * 更新最高积分文案
     */
    protected updateMaxScoreTxt(): void {
        if (this.view.maxScoreTxt) {
            this.view.maxScoreTxt.text = this.model.getMaxScoreTxt("{0}");
        }
    }

    /**
     * 更新奖品名字文案
     */
    protected updateOptionNameTxt(): void {
        if (this.view.optionNameTxt) {
            this.view.optionNameTxt.text = this.model.optionName;
        }
    }

    /**
     * 更新图片
     */
    protected updateOptionImg(): void {
        if(this.view.optionImg){
            this.view.optionImg.source=this.model.optionImg;
        }
    }



    public init(){
        YtDisplayPool.ins.displayPool[SlModuleName.GAME_WIN_PANEL]=this;
    }


    /**
     * 添加事件
     * */
    protected addEvent(){
        if(this.view.closeBtn){
            this.addClick(this.view.closeBtn,this.onClick_closeBtn.bind(this))
        }
        if(this.view.useBtn){
            this.addClick(this.view.useBtn,this.onClick_useBtn.bind(this))
        }
        if(this.view.optionImg){
            this.addClick(this.view.optionImg,this.onClick_useBtn.bind(this))
        }
        if(this.view.againBtn){
            this.addClick(this.view.againBtn,this.onClick_againBtn.bind(this))
        }
    }

    /**
     * 移除事件
     * */
    protected removeEvent(){
        if(this.view.closeBtn){
            this.removeClick(this.view.closeBtn)
        }
        if(this.view.useBtn){
            this.removeClick(this.view.useBtn)
        }
        if(this.view.optionImg){
            this.removeClick(this.view.optionImg)
        }
        if(this.view.againBtn){
            this.removeClick(this.view.againBtn)
        }
    }


    /**
     * 更新页面
     * @param args
     */
    public updateData(...args): void {
        super.updateData();
        this.updateCountTxt();
        this.updateRankTxt();
        this.updateCurrScoreTxt();
        this.updateMaxScoreTxt();
        this.updateOptionNameTxt();
        this.updateOptionImg();
    }

    protected onClick_useBtn(e): void {
        this.enableMouseEvt(false)
        this.model.onUse();
    }

    protected onClick_closeBtn(e): void {
        this.enableMouseEvt(false)
       // this.hide();
        this.model.getInfo(this.getInfo_result.bind(this));
    }
    protected getInfo_result(): void {
        YtModuleManager.ins.openModule(SlModuleName.GAME_START_GUI);
        this.enableMouseEvt(true);
    }

    protected onClick_againBtn(e): void {
        this.enableMouseEvt(false)
        this.model.doStart(this.doStart_result.bind(this));
    }
    protected doStart_result(e): void {
        this.onClosed()
        this.hide();
        setTimeout(()=>{
            YtModuleManager.ins.openModule(SlModuleName.GAME_PLAY_GUI);
            YtModuleManager.ins.openModule(SlModuleName.GAME_PLAY_SCENE);
        },500)
        this.enableMouseEvt(true);
    }
}