import {YtModule} from "duiba-yt";
import {YtDisplayPool} from "duiba-yt";
import {SlModuleName} from "../../enum/SlModuleName";
import {YtModuleManager} from "duiba-yt";
import { GameStartModel, TwFun } from "duiba-tw";
import { IModuleData, GCache, GFun, GDispatcher } from 'duiba-tc';

export class SlGameStartModule extends YtModule {


     /**
     * 数据
     */
    protected model: GameStartModel;

    protected initModel(): void {
        this.model = new GameStartModel();
    }

    //游戏场景对象

    protected gameSceneObject:any;

    constructor(){
        super()
    }


    public init():void{
        YtDisplayPool.ins.displayPool[SlModuleName.GAME_START_GUI]=this;
    }


    /**
     * 更新开始按钮状态
     */
    protected updateStartBtnStatus(): void {
        if (this.view.startBtn) {
            const enable: boolean = this.model.startBtnEnable;
          //  this.view.startBtn.mouseEnable = enable;
            this.enableMouseEvtView(this.view.startBtn,enable)
           /*  if (enable) {
                this.view.startBtn.gotoAndStop(1);
            } else {
                this.view.startBtn.gotoAndStop(3);
            } */
        }
    }


      /**
     * 更新次数文案
     */
    protected updateCountTxt(): void {
        if (this.view.countTxt) {
            this.view.countTxt.text = ""+this.model.countTxt;
        }
    }


    /**
     * 添加事件
     * */
    protected addEvent(): void{

        //开始游戏
        if(this.view.startBtn){
            this.addClick(this.view.startBtn,this.onClick_startBtn.bind(this))
        }

        //活动规则
        if(this.view.ruleBtn){
           this.addClick(this.view.ruleBtn,this.onClick_ruleBtn.bind(this))
        }
       
        //活动奖品
        if(this.view.optionBtn){
            this.addClick(this.view.optionBtn,this.onClick_optionBtn.bind(this))
        }

        //兑换记录
        if (this.view.recordBtn) {
            this.addClick(this.view.recordBtn,this.onClick_recordBtn.bind(this))
        }

         //实时排行榜
         if(this.view.realTimeRankBtn) {
            this.addClick(this.view.realTimeRankBtn,this.onClick_realTimeRankBtn.bind(this))
        }
       
    }


    protected removeEvent(){
         //开始游戏
         if(this.view.startBtn){
            this.removeClick(this.view.startBtn)
        }

        //活动规则
        if(this.view.ruleBtn){
            this.removeClick(this.view.ruleBtn)
        }
       
        //活动奖品
        if(this.view.optionBtn){
            this.removeClick(this.view.optionBtn)
        }

        //兑换记录
        if (this.view.recordBtn) {
            this.removeClick(this.view.recordBtn)
        }

         //实时排行榜
         if(this.view.realTimeRankBtn) {
            this.removeClick(this.view.realTimeRankBtn)
        }
    }


    protected onClick_ruleBtn(): void {
        this.enableMouseEvt(false);
        this.model.getRule(this.getRule_result.bind(this));
    }

    protected onClick_optionBtn(): void {
        this.enableMouseEvt(false);
        this.model.getOptions(this.getOptions_result.bind(this));
    }

    protected onClick_startBtn(): void {
        this.enableMouseEvt(false);
        this.model.doStart(this.doStart_result.bind(this));
    }

  
    protected onClick_recordBtn(): void {
        this.enableMouseEvt(false);
        window.location.href = TwFun.getRecordUrl('00');
    }

    
    protected onClick_realTimeRankBtn(): void {
        this.enableMouseEvt(false);
        this.model.realtimerank(this.realtimerank_result.bind(this));
    }

    protected doStart_result(success: boolean): void {
        this.enableMouseEvt(true);
        if(!success) {
            return;
        }
        const module = YtModuleManager.ins.getModule(SlModuleName.GAME_GUIDE_GUI);
        if(GCache.readCache('guide') || !module) {
            YtModuleManager.ins.openModule(SlModuleName.GAME_PLAY_SCENE);
        } else {
            YtModuleManager.ins.openModule(SlModuleName.GAME_GUIDE_GUI);
        }
    }

    protected realtimerank_result(success: boolean): void {
        this.enableMouseEvt(true);
        if(!success) {
            return;
        }
        YtModuleManager.ins.openModule(SlModuleName.GAME_REAL_TIME_RANK_PANEL);
    }

    protected getRule_result(success: boolean): void {
        this.enableMouseEvt(true);
        if(!success) {
            return;
        }
        YtModuleManager.ins.openModule(SlModuleName.RULE_PANEL);
    }

    protected getOptions_result(success: boolean): void {
        this.enableMouseEvt(true);
        if(!success) {
            return;
        }
        YtModuleManager.ins.openModule(SlModuleName.GAME_OPTION_PANEL);
        this.view.startBtn.isHitTestVisible=true;
    }


    /**
     * 更新页面
     * @param args
     */
    public updateData(...args): void {
        this.updateCountTxt();
        this.updateStartBtnStatus();
    }
}