import {YtModule} from "duiba-yt";
import {YtSceneManager} from "duiba-yt";
import {YtModuleManager} from "duiba-yt";
import {YtModuleName} from "duiba-yt";
import {YtLang} from "duiba-yt";
import {SlModuleName} from "../../enum/SlModuleName";
import { GamePlayModel } from "duiba-tw";

export class SlGameSceneModule extends YtModule{
    /**
     * 是否校验积分
     */
    protected checkScore: boolean;

    /**
     * 数据
     */
    protected model: GamePlayModel;

    protected initModel(): void {
        this.model = new GamePlayModel();
    }


    /**
     * 扩展数据
     * */
    protected other: any;

    protected score=0;

    //销毁
    public dispose(){
        var j;
        for(j in this.display){
            console.log(this.display[j])
            if( this.display[j]){
                this.display[j].dispose()
            }
        }
    }

    public show(){
        YtSceneManager.ins.change(this.display);
        this.resetGame()
    }

    protected resetGame(){
        this.model.update();
    }

    protected gameOver(): void {
        this.removeEvent();
        //将最高纪录缓存
        this.enableMouseEvt(false);
        this.removeEvent();
        this.model.cacheMaxScore(this.score);
        this.model.submit(this.submit_result.bind(this), this.score);
    }

    /**
     * 更新游戏积分
     * @param type 1 增加， 2 简少， 3重置
     * @param score 分值
     */
    protected updateScore(type: number, score: number): void {
        if (type == 1) {
            this.score += score;
        } else if (type == 2) {
            this.score -= score;
            this.score = Math.max(0, this.score);
        } else {
            this.score = score;
        }
        this.datapash();
    }

    /**
     * 阶段性提交
     */
    protected datapash(): void {
        if (this.model.checkDatapash(this.score)) {
            this.model.datapash();
        }
    }

    protected submit_result(): void {
        let moduleName: string;
        if (this.model.gameIsWinning) {
            moduleName = SlModuleName.GAME_WIN_PANEL;
        } else {
            moduleName = SlModuleName.GAME_LOSE_PANEL;
        }
        YtModuleManager.ins.openModule(moduleName);
        this.enableMouseEvt(true);
    }


    /**
     * 导入外部网格
     * @param importMeshes 网格资源列表
     * @param onSuccess 成功回调
     */
    protected ImportMeshes(importMeshes,onSuccess){
        var _length=importMeshes.length;
        var _meshes=[]
        var _skeletons=[]
        var _loadCount=0;
        importMeshes.forEach((list)=>{
            BABYLON.SceneLoader.ImportMesh(
                "",
                list.rootUrl,
                list.sceneFilename,
                YtSceneManager.ins.scene,
                (_mesh,_skeleton)=> {
                    try {
                        _meshes.push(_mesh)
                        _skeletons.push(_skeleton)
                        _loadCount++
                        if(_loadCount==_length){
                            onSuccess(_meshes,_skeletons)
                        }
                    } catch (e) {
                        console.error(e)
                    }
                }
            );
        })
    }

}