import {YtGuiManager} from "duiba-yt";
import {YtPanelModule} from "duiba-yt";
import {YtGuiCreate} from "duiba-yt";
import {YtDisplayPool} from "duiba-yt";
import {SlModuleName} from "../../enum/SlModuleName";
import { GameRealTimeRankModel, TwFun } from "duiba-tw";

export class SlGameRealTimeRankModule extends YtPanelModule {

       /**
     * 数据
     */
    protected model: GameRealTimeRankModel;

    protected initModel(): void {
        this.model = new GameRealTimeRankModel();
    }


    //UI配置

    protected uiConfig={
        bodyWidth:"440px",
        bodyHeight:"680px",
        bodyTop:"260px",
        bodyLeft:"260px",
        isVertical:true,
    }

    constructor(){
        super()
    }

      /**
     * 打开后
     * */
    protected onOpened(...args){
        this.htmlView=this.htmlCreate(this.uiConfig,this.model.userList)
    }


    public init(){
        YtDisplayPool.ins.displayPool[SlModuleName.GAME_REAL_TIME_RANK_PANEL]=this;
    }


    /**
     * 添加事件
     * */
    protected addEvent(){
        if(this.view.closeBtn){
            this.addClick(this.view.closeBtn,this.onClick_closeBtn.bind(this))
        }
    }


    protected onClick_closeBtn(e): void {
        this.enableMouseEvt(false)
        this.hide();
    }


    protected removeEvent(){
        if(this.view.closeBtn){
            this.enableMouseEvt(true)
            this.removeClick(this.view.closeBtn)
        }
    }


    /**
     * 更新页面
     * @param args
     */
    public updateData(...args): void {
        if (!this.isInit) {
            this.initUI();
            this.isInit = true;
        }
        this.view.closeBtn.isHitTestVisible=true;
    }

      /**
     * 关闭前
     * */
    protected onClose(){
        if(document.getElementById("viewNode")){
          try {
              document.body.removeChild(this.viewNode)
          }catch (e) {
              console.log(e)
          }
          }
      }
}