import {YtPanelModule} from "duiba-yt";
import {YtDisplayPool} from "duiba-yt";
import {SlModuleName} from "../../enum/SlModuleName";
import {YtModuleManager} from "duiba-yt";
import { GameLoseModel } from 'duiba-tw';

export class SlGameLoseModule extends YtPanelModule {
    constructor(){
        super()
    }


  /**
     * 数据
     */
    protected model: GameLoseModel;

    protected initModel(): void {
        this.model = new GameLoseModel();
    }


     /**
     * 更新剩余次数文案
     */
    protected updateCountTxt(): void {
        if (this.view.costTxt) {
            this.view.costTxt = this.model.costTxt;
        }
    }

    /**
     * 更新排行文案
     */
    protected updateRankTxt(): void {
        if (this.view.rankTxt) {
            this.view.rankTxt.text = this.model.getRankTxt();
        }
    }

    /**
     * 更新当前积分文案
     */
    protected updateCurrScoreTxt(): void {
        if (this.view.currScoreTxt) {
            this.view.currScoreTxt.text = this.model.getCurrScoreTxt();
        }
    }

    /**
     * 更新最高积分文案
     */
    protected updateMaxScoreTxt(): void {
        if (this.view.maxScoreTxt) {
            this.view.maxScoreTxt.text = this.model.getMaxScoreTxt();
        }
    }

    /**
     * 隐藏
     */
    protected hide(): void {
        this.removeEvent();
        this.panelsAn.hide(this.view.view,()=>{
            this.onClose()
        },()=>{
            this.onClosed()
        })
    }

    public init(){
        YtDisplayPool.ins.displayPool[SlModuleName.GAME_LOSE_PANEL]=this;
    }


    /**
     * 添加事件
     * */
    protected addEvent(){
        if(this.view.closeBtn){
            this.addClick(this.view.closeBtn,this.onClick_closeBtn.bind(this))
        }
    }


    protected onClick_closeBtn(e): void {
        this.enableMouseEvt(false)
        this.hide();
    }


    protected removeEvent(){
        if(this.view.closeBtn){
            this.enableMouseEvt(true)
            this.removeClick(this.view.closeBtn)
        }
    }


    /**
     * 更新页面
     * @param args
     */
    public updateData(): void {
        super.updateData();
        this.updateCountTxt();
        this.updateRankTxt();
        this.updateCurrScoreTxt();
        this.updateMaxScoreTxt();
    }

    /**
     * 关闭后
     * */
    protected onClosed(){
        super.onClosed()
        this.enableMouseEvt(true)
        YtModuleManager.ins.openModule(SlModuleName.GAME_START_GUI);
    }
}