import {YtModule} from "duiba-yt";
import {YtDisplayPool} from "duiba-yt";
import { SlModuleName } from "../../enum/SlModuleName";
import {YtModuleManager} from "duiba-yt";
import { GCache } from 'duiba-tc';

/**
 *Created by cuiliqiang on 2018/3/16
 * 游戏结束场景
 */
export class SlGameGuideModule extends YtModule {
    protected totalFrames=1;

    public init(){
        YtDisplayPool.ins.displayPool[SlModuleName.GAME_GUIDE_GUI]=this;
    }

   /**
     * 当前步骤
     */
    protected currStep: number;

    /**
     * 最大步骤
     */
    protected maxStep: number;

    public updateData(): void {
        super.updateData();
        this.maxStep = this.totalFrames;
        this.currStep = 1;
    }


     /**
     * 引导是否完成
     */
    public isComplete(): boolean {
        if(this.currStep >= this.maxStep) {
            GCache.writeCache('guide', 'true');
            return true;
        }
        return false;
    }

  

    protected addEvent(): void {
        super.addEvent();
        if (this.view.sureBtn) {
            this.addClick(this.view.sureBtn, this.onClick_sureBtn.bind(this));
        }
    }

    protected onClick_sureBtn(): void {
        this.currStep ++;
        if (this.isComplete()) {
            YtModuleManager.ins.openModule(SlModuleName.GAME_PLAY_SCENE);
        } else {
           // this.view.gotoAndStop(this.currStep);
        }
    }

   
    protected removeEvent(): void {
        super.removeEvent();
        if (this.view.sureBtn) {
            this.removeClick(this.view.sureBtn);
        }
    }
}