import {YtModule} from "duiba-yt";
import {YtAnimationGui} from "duiba-yt";
import {YtSceneManager} from "duiba-yt";
import {YtGuiManager} from "duiba-yt";
import {YtDisplayPool} from "duiba-yt";
import { GameEndModel, TwFun } from "duiba-tw";
import { SlModuleName } from "../../enum/SlModuleName";
import { SlLang } from "../../util/SlLang";
import {YtModuleManager} from "duiba-yt";

/**
 *Created by cuiliqiang on 2018/3/16
 * 游戏结束场景
 */
export class SlGameEndModule extends YtModule {

   

    //面板隐藏显示实例
    protected panelsAn=new YtAnimationGui(YtSceneManager.ins.scene,YtGuiManager.ins.fullscreenUI)

    public init(){
        YtDisplayPool.ins.displayPool[SlModuleName.GAME_END_GUI]=this;
    }

    /**
     * 数据
     */
    protected model: GameEndModel;

    protected initModel(): void {
        this.model = new GameEndModel();
    }

    public updateData(...args): void {
        this.updateStatusTxt();
        this.updateScoreTxt();
    }

    /**
     * 更新活动状态文案
     * @param str 
     */
    protected updateStatusTxt(str: string = SlLang.lang_004): void {
        if (this.view.statusTxt) {
            this.view.statusTxt.text = str;
        }
    }

    /**
     * 更新积分文案
     */
    protected updateScoreTxt(): void {
        if (this.view.scoreTxt) {
            this.view.scoreTxt.text=this.model.getScoreTxt();
        }
    }

    protected addEvent(): void {
        //兑换记录
        if (this.view.recordBtn) {
            this.addClick(this.view.recordBtn, this.onClick_recordBtn.bind(this));
        }

        //活动规则
        if (this.view.ruleBtn) {
           this.addClick(this.view.ruleBtn, this.onClick_ruleBtn.bind(this));
        }

        //活动奖品
        if (this.view.optionBtn) {
            this.addClick(this.view.optionBtn, this.onClick_optionBtn.bind(this));
        }
    }

    protected onClick_recordBtn(e): void {
        this.delayEnable(this.view.recordBtn, 5000);
        window.location.href = TwFun.getRecordUrl('00');
    }

    protected onClick_ruleBtn(e): void {
        this.enableMouseEvt(false);
        this.model.getRule(this.getRule_result.bind(this));
    }

    protected getRule_result(success: boolean): void {
        this.enableMouseEvt(true);
        if(!success) {
            return;
        }
        YtModuleManager.ins.openModule(SlModuleName.RULE_PANEL);
    }

    protected onClick_optionBtn(e): void {
        this.enableMouseEvt(false);
        this.model.getOptions(this.getOptions_result.bind(this));
    }

    protected getOptions_result(success: boolean): void {
        this.enableMouseEvt(true);
        if(!success) {
            return;
        }
        YtModuleManager.ins.openModule(SlModuleName.GAME_OPTION_PANEL);
    }

    protected removeEvent(): void {
        if (this.view.recordBtn) {
           this.removeClick(this.view.recordBtn)
        }

        if (this.view.ruleBtn) {
          this.removeClick(this.view.ruleBtn)
        }

        if (this.view.prizeBtn) {
            this.removeClick(this.view.prizeBtn)
        }
    }
}