import {YtGuiManager} from "duiba-yt";
import {YtPanelModule} from "duiba-yt";
import {YtDisplayPool} from "duiba-yt";
import {SlModuleName} from "../../enum/SlModuleName";
import {SlSysLang} from "../../util/SlSyslang";
import { RuleModel, TwFun } from "duiba-tw";
import {YtGuiCreate} from "duiba-yt";

export class SlRuleModule extends YtPanelModule {

     /**
     * 数据
     */
    protected model: RuleModel;

    protected initModel(): void {
        this.model = new RuleModel();
    }


    constructor(){
        super()
    }

    protected config={
        x:16,
        y:47,
        width:68,
        height:60,
        lineHeight:7,
        fontSize:3,
        color:"#000000"
    }

   
    protected initHtml(x,y,width,height,lineHeight,fontSize,color,val){
        this.section = document.createElement('div');
        this.section.id="section"
        this.section.innerHTML=`
            <div>
            <style>
            #section{position: fixed;overflow-x: hidden;overflow-y: auto;top: ${y}vw; left: ${x}vw;width: ${width}vw;height: ${height}vw;line-height: ${lineHeight}vw;font-family: ${SlSysLang.lang_015};font-size: ${fontSize}vw;color: ${color};}
            </style>
              <div>${val}</div>
            </div>`;

        YtGuiCreate.ins.preventDefault(this.section)
    }

    protected appendHtml(){
        document.body.appendChild(this.section);
    }

  
    public init(){
        YtDisplayPool.ins.displayPool[SlModuleName.RULE_PANEL]=this;
    }


   /**
     * 添加事件
     * */
    protected addEvent(){
        if(this.view.closeBtn){
            this.addClick(this.view.closeBtn,this.onClick_closeBtn.bind(this))
        }
    }


    protected onClick_closeBtn(e): void {
        this.enableMouseEvt(false)
        this.hide();
    }


    protected removeEvent(){
        if(this.view.closeBtn){
            this.enableMouseEvt(true)
            this.removeClick(this.view.closeBtn)
        }
    }


    /**
     * 更新页面
     * @param args
     */
    public updateData(...args): void {
        if (!this.isInit) {
            this.initUI();
            this.isInit = true;
        }
        this.view.closeBtn.isHitTestVisible=true;
    }

    protected onOpened(){
        this.initHtml(this.config.x,this.config.y,this.config.width,this.config.height,this.config.lineHeight,this.config.fontSize,this.config.color,this.model.ruleTxt)
        this.appendHtml()
    }

    /**
     * 关闭前
     * */
    protected onClose(){
        this.removeHtml()
    }

    protected removeHtml(){
        if(this.section){
            document.body.removeChild(this.section);
        }
    }
}