import { RegTriangle } from "../physics/RegTriangle";
import PlayScene from "../PlayScene";

export default (that: PlayScene, x, y, num) => {
    let block = that.pool.takeOut("regTriangle");
    const picType = Math.ceil(Math.random() * 2);
    const pic = new egret.Bitmap(RES.getRes(`tri${picType}_png`));
    pic.anchorOffsetX = pic.width / 2;
    pic.anchorOffsetY = pic.height * .65;
    if (!block) {
        const sprite = new egret.Sprite();
        sprite.touchEnabled = sprite.touchChildren = false;
        //背景
        const length = pic.width;
        sprite["bg"] = pic;
        sprite.addChild(pic);
        //数字
        const txt = new egret.TextField();
        txt.width = length;
        txt.height = length;
        txt.anchorOffsetX = length / 2;
        txt.anchorOffsetY = length / 2;
        txt.size = 26;
        txt.textColor = 0xffffff;
        txt.textAlign = egret.HorizontalAlign.CENTER;
        txt.verticalAlign = egret.VerticalAlign.MIDDLE;
        sprite["txt"] = txt;
        sprite.addChild(txt);
        block = new RegTriangle(length, sprite);
    } else {
        if (block.view["bg"]) {
            block.view.removeChild(block.view["bg"]);
            block.view["bg"] = pic;
            block.view.addChild(pic);
            block.view.addChild(block.view['txt']);
        }
    }
    block.view["bg"]['__resName__'] = `tri${picType}_png`;
    that.addChild(block.view)
    block.x = x;
    block.y = y;
    block.rotation = Math.random() * 360;
    block.num = num;
    that.blocks.push(block);
    block.ladderNums = 1;
}