import { Data } from "../tw/data/Data";
import { NetName } from "../tw/enum/NetName";
import { showToast } from "./ctrls/toastCtrl";
import PanelCtrl from "./ctrls/panelCtrl";
import { ModuleTypes } from "./types/sceneTypes";

export default (data?: Data, netname?: NetName) => {
    if (!data) {
        return showToast('网络异常\n请隔一段时间再尝试');
    }
    if (data.code == 'E999999999')//系统级别错误  系统异常，\n请刷新后重试。
        showToast('网络异常\n请隔一段时间再尝试');
    else if (data.code == 'E100201001')
        showToast('请登录后重试。')
    else if (data.code == 'E100201004')
        showToast('无权参与此活动')
    else if (data.code == 'E1002090002')
        PanelCtrl.instance.show('Alert3')
    else if (data.code == 'E1002090003')
        PanelCtrl.instance.show(ModuleTypes.NO_PRIZE_PANEL)
    else if (data.code == 'E100201007') {
        showToast(`对不起\n您的${CFG.unitName}不足`);
    }
    else if (data.code == 'E100202007' || data.code == 'E100202008' || data.code == 'E100202009' || data.code == 'E100202010')
        showToast('对不起\n您的次数不足。')
    else//其他异常
        showToast('网络异常\n请隔一段时间再尝试')
}