import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../components/Panel";
import Loading from "../components/Loading";
export default class PanelCtrl {
    private _parent: egret.Sprite;
    private _mask: egret.Sprite;
    static _instance: PanelCtrl;
    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    init(parent: egret.Sprite) {
        this._parent = parent;
    }

    show(type: any, data?) {
        this.closeCurrent(true);
        const cls = this._panelClassMap[type];
        const panel: Panel = new cls(data);
        this.addMask();
        if (!window['development']) {
            Loading.instace.show();
            const key = panel.skinKey.toLowerCase();
            const reskey = panel.skinResKey || key;
            const p = Promise.all([RES.getResAsync(`${reskey}_json`), RES.getResAsync(`${reskey}_png`)]);
            p.then(() => {
                Loading.instace.hide();
                this.showAfterLoadAtlas(panel, data);
            })
        } else {
            this.showAfterLoadAtlas(panel, data);
        }
        return panel;
    }

    showAfterLoadAtlas(panel: Panel, data) {
        panel.loadSkin();
        this._current = panel;
        panel.start(data);
        this.add(panel);
        egret.Tween.get(panel).set({ y: -200 }).to({ y: 0 }, 500, egret.Ease.quartOut);
    }

    addMask() {
        if (!this._mask) {
            this._mask = new egret.Sprite();
            this._mask.touchEnabled = true;
            this._mask.graphics.beginFill(0, .7);
            this._mask.graphics.drawRect(0, 0, 750, 1624);
            this._mask.graphics.endFill();
        }
        this._mask.alpha = 1;
        this._parent.addChild(this._mask);
    }

    removeMask(rightNow = false) {
        if (this._mask) {
            if (rightNow) {
                this._parent.removeChild(this._mask);
            } else
                egret.Tween.get(this._mask).to({ alpha: 0 }, 100, egret.Ease.quartIn).call(
                    () => this._parent.removeChild(this._mask), this);
        }
    }

    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    }

    private remove(panel: Panel, rightNow = false) {
        if (rightNow) {
            this._parent.removeChild(panel);
            this.removeMask(rightNow);
            return;
        }
        const tw = egret.Tween.get(panel);
        tw.to({ y: panel.stage.stageHeight }, 100, egret.Ease.quartIn)
            .call(() => {
                this._parent.removeChild(panel);
                this.removeMask();
            }, this);
    }

    private onPanelHide(e: egret.Event) {
        const panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel, e.data.rightnow);
        this._current = null;
    }

    private _panelClassMap: any;
    registerPanel(name, config) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = config.cls;
    }


    private _current: Panel;

    closeCurrent(rightNow = false) {
        if (this._current) {
            this.remove(this._current, rightNow);
            this._current = null;
        }
    }
}