import RelivePanel from "../../src/panels/RelivePanel";
import RewardPanel from "../../src/panels/RewardPanel";
import ShareAlertPanel from "../../src/panels/ShareAlertPanel";
import PlayScene from "../../src/playScene/PlayScene";
import StartScene from "../../src/startScene/StartScene";
import getResPath from "../new_tc/getResPath";
import { DataManager } from "../tw/manager/DataManager";
import { NetManager } from "../tw/manager/NetManager";
import { Buried } from "../tw/util/Buried";
import AssetAdapter from "./adapter/AssetAdapter";
import ThemeAdapter from "./adapter/ThemeAdapter";
import Alert from "./components/Alert";
import HTMLRulePanel from "./components/HTMLRulePanel";
import Loading from "./components/Loading";
import NoPrizePanel from "./components/NoPrizePanel";
import OptionsPanel from "./components/OptionsPanel";
import PrizePanel from "./components/PrizePanel";
import RulePanel from "./components/RulePanel";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import { ModuleTypes } from "./types/sceneTypes";
import layers from "./views/layers";
import Alert1Panel from "../../src/panels/Alert1Panel";
import Alert3Panel from "../../src/panels/Alert3Panel";
import Alert2Panel from "../../src/panels/Alert2Panel";
import Prize1Panel from "../../src/panels/Prize1Panel";
import Prize2Panel from "../../src/panels/Prize2Panel";
import Prize3Panel from "../../src/panels/Prize3Panel";
import Start1Scene from "../../src/start1/StartScene1";
import TaskPanel from "../../src/panels/TaskPanel";
import SucccessPanel from "../../src/panels/SuccessPanel";

export default class MainBase extends eui.UILayer {
    constructor() {
        super();
        Loading.instace.loadImage();
        DataManager.ins.customCfgData = window['CFG'];
        this.getData();
    }

    protected registerModules() {
        const panels = [
            [ModuleTypes.ALERT_PANEL, { cls: Alert }],
            [ModuleTypes.RELIVE_PANEL, { cls: RelivePanel }],
            [ModuleTypes.RULE_PANEL, { cls: RulePanel }],
            [ModuleTypes.HTML_RULE_PANEL, { cls: HTMLRulePanel }],
            [ModuleTypes.OPTIONS_PANEL, { cls: OptionsPanel }],
            [ModuleTypes.PRIZE_PANEL, { cls: PrizePanel }],
            [ModuleTypes.NO_PRIZE_PANEL, { cls: NoPrizePanel }],
            ['rewardPanel', { cls: RewardPanel }],
            ['shareAlert', { cls: ShareAlertPanel }],
            ['Alert1', { cls: Alert1Panel }],
            ['Alert2', { cls: Alert2Panel }],
            ['Alert3', { cls: Alert3Panel }],
            ['Prize1', { cls: Prize1Panel }],
            ['Prize2', { cls: Prize2Panel }],
            ['Prize3', { cls: Prize3Panel }],
            ['TaskPanel', { cls: TaskPanel }],
            ['SuccessPanel', { cls: SucccessPanel }],
            
        ];

        const scenes = [
            [ModuleTypes.START_SCENE, { cls: Start1Scene }],
            [ModuleTypes.PLAY_SCENE, { cls: PlayScene }]
        ];

        panels.forEach(item => PanelCtrl.instance.registerPanel(item[0], item[1]));
        scenes.forEach(item => SceneCtrl.instance.registerScene(item[0], item[1]));

        // NetManager.ins.onNotSuccess = (msg) => {
        //    s
        // }
    }

    protected getData() {

    }

    protected createChildren(): void {
        super.createChildren();
        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        })

        egret.lifecycle.onPause = () => {
            // egret.ticker.pause();
        }

        egret.lifecycle.onResume = () => {
            // egret.ticker.resume();
        }

        //inject the custom material parser
        //注入自定义的素材解析器
        const assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        layers.init(this);
        Loading.init(layers.topLayer);
        // Loading.instace.show();

        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        this.registerModules();

        // Loading.instace.show();

        RES.setMaxLoadingThread(10);
        this.runGame().catch(e => {
            console.log(e);
        })
    }

    private async runGame() {
        await this.loadResource()

        if (!window['development'])//正式环境
            RES.getResAsync(`common_json`);//弱网下需要toast资源的缓存
        else {
        }

        this.createGameScene();
    }

    private async loadResource() {
        try {
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            const theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);
        })
    }

    protected async  createGameScene() {
        await Promise.all([this.getIndex(),this.getProjectUserInfo()]);
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }


    getProjectUserInfo() {
        return new Promise((r) => {
            NetManager.ins.getProjectUserInfo(async () => {
                
                r();
            });
        })
    }
    ajaxElement() {
        return new Promise((r) => {
            NetManager.ins.ajaxElement(async () => {
                Buried.init();
                r();
            });
        })
    }
    getIndex() {
        return new Promise((r) => {
            NetManager.ins.yyh_index(async () => {
                r();
            });
        })
    }
}