import StartScene from "./StartScene";

export default class Guide {
    constructor(that: StartScene, callback) {
        if (localStorage.getItem('guide')) {
            callback();
            that.removeChild(that['guide1']);
            that.removeChild(that['guide2']);
        } else {
            that.addChild(that['guide1']);
            that.addChild(that['guide2']);
            that['guide1'].visible = true;
            that['guide2'].visible = false;
            that['guide1'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                that.removeChild(that['guide1']);
                that['guide2'].visible = true;
            });
            that['guide2'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                that.removeChild(that['guide2']);
                localStorage.setItem('guide', '1');
                callback();
            });
        }
    }
}