import Panel from "../../libs/new_wx/components/Panel";
import hdGameManySubmit from "../../libs/new_tw/ctrls/hdGameManySubmit";
import { showResult } from "../utils";
import Loading from "../../libs/new_wx/components/Loading";
export default class TreasurePanel extends Panel {
    start(data) {
        this.updatePanel();
    }

    updatePanel() {
        this.tweenGroup.addEventListener('complete', this.onTweenGroupComplete, this);
        this.tweenGroup.play(0);
        this.bg2.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onOpenTreasure, this);
    }

    onOpenTreasure() {
        this.tweenGroup.removeEventListener('complete', this.onTweenGroupComplete, this);
        this.tweenGroup.stop();
        this.bg2.touchEnabled = false;
        Loading.instace.show();
        hdGameManySubmit((success) => {
            Loading.instace.hide();
            showResult(success);
        }, 10);
    }

    private onTweenGroupComplete(): void {
        this.tweenGroup.play(0);
    }

    get skinKey() { return 'Treasure' }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }

    destroy() {
        super.destroy();
        this.tweenGroup.removeEventListener('complete', this.onTweenGroupComplete, this);
    }

    bg2: eui.Image;
    tweenGroup: egret.tween.TweenGroup;
}