import gameDoDojoin from "../../libs/new_tw/ctrls/gameDoDojoin";
import Loading from "../../libs/new_wx/components/Loading";
import Panel from "../../libs/new_wx/components/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { Buried } from "../../libs/tw/util/Buried";
import { TwFun } from "../../libs/tw/util/TwFun";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import { ModuleTypes } from "../../libs/new_wx/types/sceneTypes";

export default class StartUIPanel extends Panel {
    ruleBtn;
    recordBtn;
    start() {
        const ele = DataManager.ins.reconAjaxElementData.element;
        const msg = `小豆乐园上新啦！ \n玩游戏抽好礼，快来试试吧！\n每次将扣除${ele.needCredits}个${window['CFG'].unitName}`;
        this.data.msg = msg;
        //今日游戏机会：3次
        // this.data.msg = `消耗${ele.needCredits}${CFG.unitName}\n赢取金币大礼包`;
        this.showlog();

        if (this.ruleBtn)
            this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        if (this.recordBtn)
            this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
    }

    onTap_recordBtn(e: egret.Event) {
        window.location.href = TwFun.getRecordUrl('00');
    }

    onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }

    onTouchTap_closeBtn() {
        NetManager.ins.clickLog(this.getlogItem());
        this['closeBtn'].touchEnabled = false;
        Loading.instace.show();
        gameDoDojoin((success) => {
            if (success) {
                this.hidePanel();
                setTimeout(() => {
                    NetManager.ins.reconAjaxElement(() => { });
                }, 500);
            }
            Loading.instace.hide();
            this['closeBtn'].touchEnabled = true;
        });
    }

    get skinKey() { return 'StartUI' }

    showlog() {
        NetManager.ins.showLog(this.getlogItem());
    }

    getlogItem(i = 1) {
        const Dpm = Buried.connectDpm(110, 1, i); // 点击埋点
        const Dcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        return Buried.createExposure(Dpm, Dcm);
    }
}