import wait from "../../libs/new_tc/wait";
import hdGameManySubmit from "../../libs/new_tw/ctrls/hdGameManySubmit";
import Panel from "../../libs/new_wx/components/Panel";
import centerAnchorOffset from "../../libs/new_wx/views/centerAnchorOffset";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { showResult } from "../utils";
export default class SlotPanel extends Panel {
  optionList: any;
  itemList: any;
  conveyorList: any;
  itemWidth: number;
  speed: number;
  cutSpeed: number;
  prizeItem: any;
  Do: number;
  dis: number;
  N: number;
  INITALSPEED: number;

  start() {
    this.optionList = []
    this.itemList = []
    this.conveyorList = []
    this.itemWidth = 430
    this.speed = 1
    this.dis = 0
    this.N = 2
    this.INITALSPEED = 30
    this.initSlot();
  }

  private async initSlot() {
    this['slotStartBtn'] && this['slotStartBtn'].once(egret.TouchEvent.TOUCH_TAP, this.onTap_slotStart, this);
    this.optionList = DataManager.ins.reconAjaxElementData.options.filter(item => {
      return item.scoreArea === '11,20'
    });
    this.optionList.push(DataManager.ins.reconAjaxElementData.thanksOpt)

    this.drawMask();
    this.renderSlotWrap();
  }

  play() {
    egret.startTick(this.onTick, this)
  }

  onTick() {
    this.itemList.forEach(item => {
      item.x -= this.speed
      if (item.x < -300) {
        item.x = this.itemList[this.itemList.length - 1].x + this.itemWidth
        this.itemList.push(item)
        this.itemList.shift()
      }
    })
    this.conveyorList.forEach(item => {
      item.x -= this.speed
      if (item.x < -300) {
        item.x = this.conveyorList[this.conveyorList.length - 1].x + item.width
        this.conveyorList.push(item)
        this.conveyorList.shift()
      }
    })
    if (this.Do) {
      this.dis += this.speed
      if (this.dis >= this.Do) {
        this.dis = this.Do
        this.speed = 0
        egret.stopTick(this.onTick, this);
        wait(500).then(() => {
          showResult(this.success);
        });
        return
      }
      this.speed = (1 - this.dis / this.Do) * this.INITALSPEED
      if (this.speed < 5) {
        this.speed = 5
      }
    }
    return false
  }

  onTap_slotStart() {
    this['slotStartBtn'].touchEnabled = false;
    this.calcSpeed(1, this.INITALSPEED)
      .then(() => {
        this.stop()
      });
  }

  calcSpeed(count, val) {
    return new Promise((resolve, reject) => {
      const calc = () => {
        const flag = count > 0 ? this.speed < val : this.speed > val
        this.speed += count
        if (flag) {
          setTimeout(() => {
            calc()
          }, 50)
        } else {
          resolve()
        }
      }
      calc()
    })

  }
  success;
  stop() {

    hdGameManySubmit((success) => {
      this.success = success;
      let lotteryId;
      if (success && DataManager.ins.getCustomOrderStatusData.lottery) {
        lotteryId = DataManager.ins.getCustomOrderStatusData.lotteryId;
      } else {
        lotteryId = DataManager.ins.reconAjaxElementData.thanksOpt.id;
      }
      let hashIndex = 0;
      for (let i = 0; i < this.optionList.length; i++) {
        const opt = this.optionList[i];
        if (opt.id == lotteryId)
          hashIndex = i;

      }
      wait(1000).then(() => {
        // tslint:disable-next-line:prefer-for-of
        for (let i = 0; i < this.itemList.length; i++) {
          const item = this.itemList[i];
          if (item.userdata.id == lotteryId)
            this.prizeItem = item;
        }
        this.Do = (this.prizeItem ? this.prizeItem.x : -100) - 384 + this.N * this.itemList.length * this.itemWidth
      })
    }, 20);
  }

  gameReset() {
    this.speed = 1
    this.prizeItem = null
    const slotWrap: any = this.getChildByName('slotWrap')
    slotWrap.removeChildren()
    this.renderOptions(slotWrap)
    this.renderConveyor(slotWrap)
  }

  private renderConveyor = async (container: any) => {
    const conveyor = new egret.Bitmap(RES.getRes('conveyor_png'));
    // await loadImageByUrl('conveyor_png').then((img: any) => {
    //   conveyor = img
    // })
    this.conveyorList = []
    for (let i = 0; i < this.optionList.length; i++) {
      let conveyorHash
      conveyorHash = cloneImage(conveyor)
      conveyorHash.y = 244
      conveyorHash.x = 150 + conveyor.width * (i - 1)
      this.conveyorList.push(conveyorHash)
    }
    this.conveyorList.forEach(element => { container.addChild(element) })
  }

  private drawMask = () => {
    const circle = new egret.Shape();
    circle.graphics.beginFill(0x0000ff);
    circle.graphics.drawCircle(0, 0, 432 / 2);
    circle.graphics.endFill();
    circle.x = 159 + 432 / 2
    circle.y = 367 + 432 / 2
    this.addChild(circle)
    this.mask = circle
  }

  private renderSlotWrap = () => {
    const slotWrap = new egret.DisplayObjectContainer()
    this.renderOptions(slotWrap)
    this.renderConveyor(slotWrap)
    slotWrap.y = 450
    slotWrap.name = 'slotWrap'
    this.addChild(slotWrap)
    this.play()
    slotWrap.mask = this.mask
    this.addChild(this['slotWrapTop'])
  }

  renderText(text) {
    const textField = new egret.TextField();
    textField.text = text;
    textField.textColor = 0xffffff;
    textField.size = 30;
    textField.width = 300;
    // textField.border = true;
    // textField.borderColor = 0xff0000;
    // textField.lineSpacing = 20;
    // textField.y = 0
    textField.textAlign = egret.HorizontalAlign.CENTER;
    textField.anchorOffsetX = textField.width / 2;
    return textField;
  };

  private renderOptions = (container: any) => {
    this.itemList = []
    let x = window.innerWidth - 430
    this.optionList.reduce((sum, item) => {
      const gift = new egret.Sprite();
      return sum.then(() => {
        return loadImageByUrl(item.logo).then((image: any) => {
          gift.addChild(image);
          const text = this.renderText(item.name);
          text.x = image.width / 2;
          text.y = image.height+57;
          gift.addChild(text);
          gift['userdata'] = item;
          gift.x = x += this.itemWidth
          gift.y = gift.height / 2
          gift.name = item.name
          centerAnchorOffset(gift)
          this.itemList.push(gift)
          container.addChild(gift)
        })
      })
    }, Promise.resolve())
  }

  get skinKey() { return 'Slot' }

  protected get closeBtns(): eui.Button[] {
    return [this['slotClose']]
  }
}

const loadImageByUrl = (url: string) => {
  url += '?'+new Date().getTime();
  return new Promise((resolve, reject) => {
    RES.getResByUrl(
      url,
      texture => {
        const image = new egret.Bitmap(texture)
        resolve(image)
      },
      this,
      'image'
    )
  })
}

const cloneImage = (bitmap: egret.Bitmap) => new egret.Bitmap(bitmap.texture);