import wait from "../../libs/new_tc/wait";
import hdGameManySubmit from "../../libs/new_tw/ctrls/hdGameManySubmit";
import Panel from "../../libs/new_wx/components/Panel";
import centerAnchorOffset from "../../libs/new_wx/views/centerAnchorOffset";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { showResult } from "../utils";

export default class RotatePannel extends Panel {
  optionList: any;
  wheelPos: any;
  prizeIndex: number;
  start() {
    this.initRotate()
  }
  private async initRotate() {
    this.optionList = DataManager.ins.reconAjaxElementData.options.filter(item => {
      return item.scoreArea === '21,30' || item.prizeType == 'thanks'
    });

    this['rotateStart'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rotateStart, this);
    this.renderOptions(this['wheel'].width / 2, this['wheel'])
  }

  onTap_rotateStart() {
    this['rotateStart'].touchEnabled = false;

    this.showAnimation(3000, 240 * 3 +500, false, null, null);
    hdGameManySubmit((success) => {
      let lotteryId;
      if (success && DataManager.ins.getCustomOrderStatusData.lottery) {
        lotteryId = DataManager.ins.getCustomOrderStatusData.lotteryId;
      } else {
        lotteryId = DataManager.ins.reconAjaxElementData.thanksOpt.id;
      }
      for (let i = 0; i < this.optionList.length; i++) {
        const opt = this.optionList[i];
        if (opt.id == lotteryId) {
          this.prizeIndex = i;
        }
      }

      const deg = this.prizeIndex > -1 ? 180 - this.prizeIndex * 45 : - 22.5
      const seconds = (1080 + deg) / 240;
      this.showAnimation(seconds * 1000, 1080 + deg, false, egret.Ease.sineOut, () => {
        wait(500).then(() => {
          showResult(success);
        });
      });
    }, 30);
  }

  renderOptions(r, container) {
    const itemDeg = 360 / 8;
    this.optionList.reduce((sum, item, index) => {
      const gift = new eui.Group;
      return sum.then(() => {
        return loadImageByUrl(item.logo).then((image: any) => {
          image.y = 220
          centerAnchorOffset(image)
          gift.addChild(image)
          gift.addChild(this.renderText(item.name))
          container.addChild(gift);
          const giftDeg = index * itemDeg
          gift.rotation = 180 + giftDeg
          gift.x = r - Math.sin((Math.PI * giftDeg) / 180) * (r - 70);
          gift.y = r + Math.cos((Math.PI * giftDeg) / 180) * (r - 70);
          gift.scaleX = gift.scaleY = 0.35;
        });
      });
    }, Promise.resolve());
    this.showAnimation(50000, 360, true, null, null);
  }

  renderText(text) {
    const textField = new egret.TextField();
    textField.text = text;
    textField.strokeColor = 0xffffff;
    textField.size = 80;
    textField.lineSpacing = 20;
    textField.y = 0
    textField.textAlign = egret.HorizontalAlign.CENTER;
    centerAnchorOffset(textField)
    return textField;
  };

  showAnimation(time, resultAngle, loop, type, cb) {
    console.log('showAnimation')
    const target = this['wheel'];
    egret.Tween.removeTweens(target);

    //这个是转盘转
    let tw = egret.Tween.get(target, {
      loop: loop
    });
    if (type)
      tw = tw.to({ rotation: resultAngle }, time, type);
    else
      tw = tw.to({ rotation: resultAngle }, time);
    cb && tw.call(cb, self);
  }

  get skinKey() { return 'Rotate' }

}

const loadImageByUrl = (url: string) => {
  url += '?'+new Date().getTime();
  // url='https://yun.duiba.com.cn/db_games/motherday428.jpg';
  return new Promise((resolve, reject) => {
    RES.getResByUrl(
      url,
      texture => {
        const image = new egret.Bitmap(texture)
        resolve(image)
      },
      this,
      'image'
    )
  })
}
