import Panel from "../../libs/new_wx/components/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { gameconfig } from "../startScene/gameconst";
import { getCurrentScore } from "../startScene/score";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import StartScene from "../startScene/StartScene";
import resurrection from "../../libs/new_tw/ctrls/resurrection";
import Loading from "../../libs/new_wx/components/Loading";
import { NetName } from "../../libs/tw/enum/NetName";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { Buried } from "../../libs/tw/util/Buried";

export default class RelivePanel extends Panel {

    start(data) {
        const resurrData = DataManager.ins.getData(NetName.RESURRECTION_ORDER_STATUS);
        let cost = 0;
        if (resurrData && resurrData.data) {
            cost = resurrData.data.resurrectionCredits;
        }
        const left = gameconfig.max - getCurrentScore();
        this.data.msg = `还差${left}分即可获得海量大礼\n是否花费少量${CFG.unitName}复活`;
        this.data.tips = `- ${cost} ${CFG.unitName}`;

        // this['reliveBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onRelive, this);
        this.showlog();
    }

    // onRelive() {
    //     this['reliveBtn'].touchEnabled = false;
    //     this.closeBtns.forEach(btn => btn.touchEnabled = false);
    //     NetManager.ins.clickLog(this.getlogItem(2));
    //     Loading.instace.show();
    //     resurrection((success) => {
    //         Loading.instace.hide();
    //         if (success) {
    //             this.hidePanel();
    //         } else {
    //             (SceneCtrl.instance.currentScene as StartScene).resetGame();
    //         }
    //     });
    // }

    onTouchTap_closeBtn() {
        super.onTouchTap_closeBtn();
        (SceneCtrl.instance.currentScene as StartScene).resetGame();
        NetManager.ins.clickLog(this.getlogItem(1));
    }

    get skinKey() { return 'Relive' }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn'], this['closeBtn2']] }


    showlog() {
        NetManager.ins.showLog(this.getlogItem(1));
        NetManager.ins.showLog(this.getlogItem(2));
    }

    getlogItem(i = 1) {
        const Dpm = Buried.connectDpm(110, 3, i); // 点击埋点
        const Dcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        return Buried.createExposure(Dpm, Dcm);
    }
}