import Panel from "../../libs/new_wx/components/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import showCustomLog from "../../libs/new_tw/ctrls/showCustomLog";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { Buried } from "../../libs/tw/util/Buried";

export default class Prize1Panel extends Panel {
    start(data) {
        const lottery = DataManager.ins.getCustomOrderStatusData.lottery;
        this.data = lottery;
        if (lottery) showCustomLog(lottery);

        // const gold = Math.ceil((Math.random() * 899 + 100));
        // const percent = Math.ceil((Math.random() * 80 + 10));
        // this.data.msg = `还差${gold}金币超过${percent}%的游戏好友`;

        const imgLoader = new egret.ImageLoader;
        imgLoader.once(egret.Event.COMPLETE, (evt) => {
            const loader = evt.currentTarget as egret.ImageLoader;
            const bmd: egret.BitmapData = loader.data;
            //创建纹理对象
            const texture = new egret.Texture();
            texture.bitmapData = bmd;
            this.img.source = texture;
            const scale = 231 / bmd.height;
            this.img.height = 231;
            this.img.width = bmd.width * scale;
        }, this);
        imgLoader.load(lottery.img);

        this.showlog();
    }

    initEvents() {
        super.initEvents();
        if (this.useBtn) this.useBtn.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        if (this.img) this.img.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    onUse() {
        const lottery = DataManager.ins.getCustomOrderStatusData.lottery;
        if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
                {
                    openUrl: lottery.openUrl,
                    iosDownloadUrl: lottery.iosDownloadUrl,
                    androidDownloadUrl: lottery.androidDownloadUrl,
                    confirm: lottery.confirm ? lottery.confirm : false
                };
            window["downloadApp"]();
            if (lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.getCustomOrderStatusData.exposure);
            }
        }
        else {
            window.location.href = lottery.link;
        }
    }

    get skinKey() { return 'Prize1' }

    img: eui.Image;
    useBtn: eui.Button;

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn'], this['goBtn']]
    }

    onTouchTap_closeBtn() {
        super.onTouchTap_closeBtn();
        NetManager.ins.clickLog(this.getlogItem());
    }

    showlog() {
        NetManager.ins.showLog(this.getlogItem());
    }

    getlogItem(i = 1) {
        const Dpm = Buried.connectDpm(110, 2, i); // 点击埋点
        const Dcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        return Buried.createExposure(Dpm, Dcm);
    }
}