import layers from "../views/layers";
import Toast from "../components/Toast";

let inited = false;
let _toast: Toast;

const initToast = () => {
    if (!inited) {
        inited = true;
        const toast = new Toast();
        toast.loadSkin();
        layers.toastLayer.addChild(toast);
        toast.alpha = 0;
        _toast = toast;
    }
    return _toast;
}
export const showToast = (msg: string) => {
    const toast = initToast().start(msg);
    egret.Tween.removeTweens(toast);
    const tw = egret.Tween.get(toast);
    tw.set({ y: -200, alpha: 1 }).to({ y: 400 }, 500, egret.Ease.quartOut)
        .wait(500)
        .to({ alpha: 0 }, 300)
}