import ComponentBase from "./ComponentBase";

export default class Toast extends ComponentBase {

    toastLabel: eui.Label;
    bg: eui.Image;
    PADDING = 50;

    get skinResKey() { return 'common' }
    get skinKey(): string { return 'Toast' }

    start(msg) {
        this.toastLabel.text = msg;
        this.bg.width = Math.max(this.toastLabel.textWidth + this.PADDING * 2, 283);
        return this;
    }
}