import ComponentBase from "./ComponentBase";
export default class Scene extends ComponentBase {
    protected onSkinComplete() {
        super.onSkinComplete();
        this.createLayers();
    }

    start(data?) {
        this.addEventListener(egret.Event.ADDED_TO_STAGE, () => {
            this.height = this.stage.stageHeight;
            this.playAnimation();
        }, this);
    }

    playAnimation() {

    }

    private _map: { [key: string]: egret.Sprite }
    createLayers() {
        this._map = {};
        for (const key of this.layerKeys) {
            const layer = new egret.Sprite();
            this.addChild(layer);
            this._map[key] = layer;
        }
    }

    get extralResUrls() {
        return [];
    }

    getLayer(key) {
        return this._map[key]
    }

    protected get layerKeys() {
        return []
    }


}