import NoPrize1Panel from "../../src/panels/NoPrize1Panel";
import NoPrize2Panel from "../../src/panels/NoPrize2Panel";
import Prize1Panel from "../../src/panels/Prize1Panel";
import Prize2Panel from "../../src/panels/Prize2Panel";
import StartScene from "../../src/startScene/StartScene";
import getResPath from "../new_tc/getResPath";
import { check_webp_feature } from "../tc/util/GFun";
import { DataManager } from "../tw/manager/DataManager";
import { NetManager } from "../tw/manager/NetManager";
import { Buried } from "../tw/util/Buried";
import AssetAdapter from "./adapter/AssetAdapter";
import ThemeAdapter from "./adapter/ThemeAdapter";
import Alert from "./components/Alert";
import HTMLRulePanel from "./components/HTMLRulePanel";
import Loading from "./components/Loading";
import RulePanel from "./components/RulePanel";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import { ModuleTypes } from "./types/sceneTypes";
import layers from "./views/layers";
import StartUIPanel from "../../src/panels/StartUIPanel";
import SlotPanel from "../../src/panels/SlotPanel";
import RotatePannel from "../../src/panels/RotatePanel";
import TreasurePanel from "../../src/panels/TreasurePanel";
import RelivePanel from "../../src/panels/RelivePanel";

export default class MainBase extends eui.UILayer {
    constructor() {
        super();
        check_webp_feature();
        Loading.instace.loadImage();

        DataManager.ins.customCfgData = window['CFG'];
        this.getData();
    }

    protected registerModules() {
        const panels = [
            [ModuleTypes.ALERT_PANEL, { cls: Alert }],
            [ModuleTypes.RULE_PANEL, { cls: RulePanel }],
            [ModuleTypes.HTML_RULE_PANEL, { cls: HTMLRulePanel }],
            [ModuleTypes.START_PANEL, { cls: StartUIPanel }],
            [ModuleTypes.PRIZE1_PANEL, { cls: Prize1Panel }],
            [ModuleTypes.NO_PRIZE1_PANEL, { cls: NoPrize1Panel }],
            [ModuleTypes.PRIZE2_PANEL, { cls: Prize2Panel }],
            [ModuleTypes.NO_PRIZE2_PANEL, { cls: NoPrize2Panel }],
            [ModuleTypes.RELIVE_PANEL, { cls: RelivePanel }],

            [ModuleTypes.SLOT_PANEL, { cls: SlotPanel }],
            [ModuleTypes.ROTATE_PANEL, { cls: RotatePannel }],
            [ModuleTypes.TREASURE_PANEL, { cls: TreasurePanel }],
        ];

        const scenes = [
            [ModuleTypes.START_SCENE, { cls: StartScene }]
        ];

        panels.forEach(item => PanelCtrl.instance.registerPanel(item[0], item[1]));
        scenes.forEach(item => SceneCtrl.instance.registerScene(item[0], item[1]));
    }

    protected getData() {
    }

    protected createChildren(): void {
        super.createChildren();
        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        })

        egret.lifecycle.onPause = () => {
            // egret.ticker.pause();
        }

        egret.lifecycle.onResume = () => {
            // egret.ticker.resume();
        }

        //inject the custom material parser
        //注入自定义的素材解析器
        const assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        layers.init(this);
        Loading.init(layers.topLayer);
        Loading.instace.show();

        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        this.registerModules();
        ;
        Loading.instace.show();

        RES.setMaxLoadingThread(10);
        this.runGame().catch(e => {
            console.log(e);
        });
    }

    private async runGame() {
        await this.loadResource();
        if (!window['development']) {

            RES.getResAsync(`common_json`);
            RES.getResAsync(`noprize1_json`);
            RES.getResAsync(`noprize2_json`);
        }
        else {
            RES.getResAsync('普通未中奖_png');
            RES.getResAsync('终极未中奖_png');
            RES.getResAsync('conveyor_png');
            RES.getResAsync('toast_png');
            RES.getResAsync('bubble_png');
        }
        this.createGameScene();
    }

    private async loadResource() {
        try {
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            const theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    /**
     * 创建场景界面
     * Create scene interface
     */
    protected createGameScene() {
        NetManager.ins.reconAjaxElement(() => {
            Buried.init();
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        })

        
    }
}