import { NetName } from "../../tw/enum/NetName";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import wait from "../../new_tc/wait";

const resurrectionStatus = (callback: Function): void => {
    NetManager.ins.resurrectionStatus(callback, DataManager.ins.doJoinData.orderId, () => {
        const result = DataManager.ins.getData(NetName.RESURRECTION_ORDER_STATUS);
        return result.code == 'C000000001';
    }, 10, DataManager.ins.getData(NetName.RESURRECTION).data);
};

export default (callback) => {
    NetManager.ins.resurrection((success) => {
        if (success) {
            wait(500).then(() => {
                resurrectionStatus(callback);
            });
        } else {
            callback(false);
        }
    }, DataManager.ins.doJoinData.orderId)
}