import { IDynamicData } from "../../tw/data/game/datapash/IDynamicData";
import { NetName } from "../../tw/enum/NetName";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";

/**
 * 获取活动工具抽奖结果
 * @param callback 
 */
const getCustomOrderStatus = (callback: Function): void => {
    NetManager.ins.getCustomOrderStatus(callback, DataManager.ins.getData(NetName.HD_MANY_GAME_SUBMIT).data, () => {
        return DataManager.ins.getCustomOrderStatusData.code == 'C000000001';
    });
}

/**
 * 提交游戏成绩
 * @param callback 
 * @param score 得分
 * @param checkScore  是否校验得分
 * @param customizedType 定制类型 1推币机    
 */
const hdGameManySubmit = (callback: Function, score: number, checkScore?: boolean, customizedType?: number) => {
    const allDynamics = [];
    hdGameManySubmitData(callback, score, allDynamics, checkScore, customizedType);
}

/**
* 提交游戏成绩
* @param callback 
* @param score 得分
* @param allDynamics 防作弊数据
* @param checkScore  是否校验得分
* @param customizedType 定制类型 1推币机    
*/
const hdGameManySubmitData = (callback: Function, score: number, allDynamics: IDynamicData[][], checkScore?: boolean, customizedType?: number) => {
    NetManager.ins.hdManyGameSubmit(
        (success: boolean) => {
            if (success) {
                getCustomOrderStatus(callback);
            } else {
                callback(success);
            }
        },
        DataManager.ins.doJoinData.orderId,
        score,
        '[]',
        DataManager.ins._getHdStartStatusData.data.submitToken,
        JSON.stringify(allDynamics),
        checkScore,
        customizedType);
}

export default hdGameManySubmit;