import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import wait from "../../new_tc/wait";

const getHdGameOrderStatus = (callback: Function): void => {
    NetManager.ins.getHdGameOrderStatus(callback, DataManager.ins.doJoinData.orderId, () => {
        return DataManager.ins._getHdStartStatusData.code == 'C000000001';
    });
}

const resurrectionStatus = (callback: Function): void => {
    NetManager.ins.resurrectionStatus(callback, DataManager.ins.doJoinData.orderId, null, 0);
}

/**
 * 活动工具类型游戏子类型抽奖
 * @param callback
 * @param nextStep 下一步做什么，轮询结果或者前置开奖等
 */
const gameDoDojoin = (callback: Function, collectRuleId?: number): void => {
    if (CFG['uid'] == 'not_login') {
        window['requirelogin']();
        return;
    }
    NetManager.ins.doJoin((success: boolean) => {
        if (success) {
            getHdGameOrderStatus(callback);
            //删除复活功能
            // wait(500).then(() =>
            //     resurrectionStatus(() => { })
            // );
        } else {
            callback(success);
        }
    }, collectRuleId);
}

export default gameDoDojoin