import wait from "../../libs/new_tc/wait";
import MovieClip from "../physics/movieclip/MovieClip";
import LabelType from "./LabelType";
import { getCurrentLv, getCurrentName } from "./level";

const playMovieClip = async (parent: egret.DisplayObjectContainer, key, frames, frameInterval = 5) => {
    return new Promise(async (r) => {
        let texture: egret.SpriteSheet;
        texture = RES.getRes(key);
        if (texture) {
            await createMc(parent, texture, frames, frameInterval);
            r(1);
        }
        else {
            RES.getResAsync(key);
            wait(300).then(async () => {
                texture = RES.getRes(key);
                if (texture) {
                    await createMc(parent, texture, frames, frameInterval);
                    r(1);
                } else
                    r(0);
            })
        }
    });
}

const createMc = (parent: egret.DisplayObjectContainer, spritesheet: egret.SpriteSheet, frames: any[], frameInterval = 5) => {
    return new Promise((r) => {
        const movieclip = new MovieClip({
            spritesheet: spritesheet,
            frameInterval: frameInterval,
            frames: frames,
            position: [100 + 20 + 20, 0],
            scale: 1,
            anchor: [0, 0],
            loop: false
        });
        parent.addChild(movieclip);
        movieclip.once(egret.Event.COMPLETE, () => {
            parent.removeChild(movieclip);
            r(1)
        }, this)
    })
}

export const playSuccess = (parent) => {
    return playMovieClip(parent, 'success_json', [
        '普通碰撞_00000',
        '普通碰撞_00001',
        '普通碰撞_00002',
        '普通碰撞_00003',
        '普通碰撞_00004',
        '普通碰撞_00005',
        '普通碰撞_00006',
        '普通碰撞_00007',
        '普通碰撞_00008',
        '普通碰撞_00009',
        '普通碰撞_00010',
        '普通碰撞_00011',
    ], 3);
}

export const playBoom = (parent) => {
    return playMovieClip(parent, 'failed_json', [
        '炸弹碰撞_00000',
        '炸弹碰撞_00001',
        '炸弹碰撞_00002',
        '炸弹碰撞_00003',
        '炸弹碰撞_00004',
        '炸弹碰撞_00005',
        '炸弹碰撞_00006',
        '炸弹碰撞_00007',
        '炸弹碰撞_00008',
        '炸弹碰撞_00009',
        '炸弹碰撞_00010',
        '炸弹碰撞_00011'
    ], 3);
}

export const playScoreAni = (parent, score: number) => {
    const txt = createText(score);
    txt.scaleX = txt.scaleY = 0;
    parent.addChild(txt);
    txt.x = 375 + 100;
    txt.y = 375;
    txt.anchorOffsetX = txt.textWidth / 2;
    txt.anchorOffsetY = txt.textHeight / 2;
    egret.Tween.get(txt).to({ scaleX: 1, scaleY: 1 }, 300, egret.Ease.getBackOut(6)).wait(500)
        .to({ y: txt.y - 100, alpha: 0 }, 700).call(() => {

        })
}

const createText = (score: number) => {
    const txt = new egret.TextField();
    txt.size = 40;
    txt.bold = true;
    const prefix = score > 0 ? '+' : '';
    txt.text = prefix + score;
    txt.textColor = score > 0 ? 0xffffff : 0xffff90;
    return txt;
}

export const playBoomAlert = (that) => {
    const p1 = 200;
    egret.Tween.removeTweens(that['boomalert']);
    egret.Tween.get(that['boomalert'])
        .set({ alpha: 1 }).wait(p1)
        .set({ alpha: 0 }).wait(p1)
        .set({ alpha: 1 }).wait(p1)
        .set({ alpha: 0 }).wait(p1)
    // .set({ alpha: 1 }).wait(p1)
    // .set({ alpha: 0 }).wait(p1)
}

export const playToast = (that, type, isLeft) => {
    //toastGroup toastInfo
    let txt = '';
    const currentType = getCurrentLv();
    if (isLeft) {
        if (type == LabelType.Boom) {
            txt = `很棒！躲避了炸弹!`;
        } 
    } else {
        if (type != LabelType.Boom) {
            if (currentType == type) {
                txt = `收集到一个${getCurrentName()}!`;
            } else {
                // txt = `再接再厉哦!`;
            }
        }
    }
    if (txt == '') return;
    that['toastInfo'].text = txt;
    egret.Tween.removeTweens(that['toastGroup']);
    egret.Tween.get(that['toastGroup']).set({ alpha: 1, x: 750 })
        .to({ x: 228 }, 350, egret.Ease.backOut).wait(200).to({ alpha: 0 }, 100);
} 