import { GameStartModel } from './../../libs/tw/model/game/GameStartModel';
import { TwFun } from './../../libs/tw/util/TwFun';
import Scene from "../views/Scene";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import SceneCtrl from '../ctrls/sceneCtrl';
export default class StartScene extends Scene {

    protected get skinKey() { return 'Start' }

    public bg:eui.Image;
    public ruleBtn:eui.Button;
    public recordBtn:eui.Button;
    public startBtn:eui.Button;
    public rankBtn:eui.Button;
    public optionBtn:eui.Button;
    public dog:eui.Image;
    public myCreditsTxt:eui.Label;

    public exGameStartModel:any = new GameStartModel;
    
    /**
     * 开始
     * @param data 从上个panel或者Scene传入的数据
     */
    async start(data?) {
        this.percentWidth = 100;
        this.percentHeight = 100;
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

		// setTimeout(() => {
		// 	let scrollHeight = document.documentElement.scrollTop || document.body.scrollTop || 0;
		// 	window.scrollTo(0, Math.max(scrollHeight - 1, 0));
		// }, 100);

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad():void{
        this.recordBtn.visible = false;
        this.optionBtn.visible = false;
        this.initUI();
    }

    /**
     * 初始化UI
     */
    protected initUI() {
    }

    /**
     * 初始化所有事件
     */
    initEvents(){
        // 规则按钮
        if(this.ruleBtn){
            this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        }
        // 奖项按钮
        if(this.optionBtn){
            this.optionBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_optionBtn, this);
        }
        // 开始按钮
        if(this.startBtn){
            this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        }
        // 排行榜按钮
        if(this.rankBtn){
            this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
        }
        // 中奖纪录按钮
        if(this.recordBtn){
            this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        }    
    }

    /**
     * 移除所有事件
     */
    removeEvents(){
        // 规则按钮
        if(this.ruleBtn){
            this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        }
        // 奖项按钮
        if(this.optionBtn){
            this.optionBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_optionBtn, this);
        }
        // 开始按钮
        if(this.startBtn){
            this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        }
        // 排行榜按钮
        if(this.rankBtn){
            this.rankBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
        }
        // 中奖纪录按钮
        if(this.recordBtn){
            this.recordBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        } 
    }

    /**
     * 点击规则按钮的事件
     * @param e 
     */
    protected onTap_ruleBtn(e: egret.Event) {
        this.ruleBtn.touchEnabled = false;
        let t = setTimeout(()=>{
            clearTimeout(t);
            this.ruleBtn.touchEnabled = true;
        },1000);
        if (!DataManager.ins.getRuleData)
            NetManager.ins.getRule((success:boolean) => {
                if(success){
                    PanelCtrl.instance.show(ModuleTypes.RULE_PANEL)
                }
            });
        else
            PanelCtrl.instance.show(ModuleTypes.RULE_PANEL)
    }

    /**
     * 点击奖项按钮的事件
     * @param e 
     */
    protected onTap_optionBtn(e: egret.Event) {
        this.optionBtn.touchEnabled = false;
        let t = setTimeout(()=>{
            clearTimeout(t);
            this.optionBtn.touchEnabled = true;
        },1000);
        if (!DataManager.ins.getOptionsData)
            NetManager.ins.getOptions((success) => {
                if(success){
                    PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL)
                }
            });
        else
            PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL)
    }

    /**
     * 点击开始按钮的事件
     * @param e 
     */
    protected onTap_startBtn(e: egret.Event){
        this.startBtn.touchEnabled = false;
        setTimeout(() => {
            this.startBtn.touchEnabled = true;
        }, 500);
        SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);
    }

    /**
     * 点击排行榜按钮的事件
     * @param e 
     */
    onTap_rankBtn(e: egret.Event){
        this.rankBtn.touchEnabled = false;
        let t = setTimeout(()=>{
            clearTimeout(t);
            this.rankBtn.touchEnabled = true;
        },1000);
        if(DataManager.ins.getInfoData.status.code == 1){
            // 未登录
            let data = {msg:`未登录账号\n请先登录`, type:'requirelogin'}
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, data)
            return;
        }else{
            NetManager.ins.realtimerank((success:boolean) => {
                if(success){
                    PanelCtrl.instance.show(ModuleTypes.RANK_PANEL)
                }
            },0);
        }
    }

    /**
     * 点击中奖纪录按钮的回调
     * @param e 
     */
    onTap_recordBtn(e: egret.Event){
        this.recordBtn.touchEnabled = false;
        let t = setTimeout(()=>{
            clearTimeout(t);
            this.recordBtn.touchEnabled = true;
        },1000);
        window.location.href = TwFun.getRecordUrl('00');
    }



    /**
     *  开始游戏的回调
     */ 
    private doStartResult(success:boolean){
        if(!success) {
            return;
        }
        SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);
        this.startBtn.touchEnabled = true;
    }

    /**
     * 开始游戏 
     * @param callback 
     * @param isAgain
     * @param credits 
     * @param customizedType 
     */
    public doStart(callback: Function, isAgain = false, credits?: number, customizedType?: number): void {
        if(window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager.ins.doStart((success: boolean) => {
            if(success) {
                this.getStartOrderStatus(callback, customizedType);
            } else {
                callback(success);
            }
        },
        isAgain,
        credits,
        customizedType);
    }

    /**
     * 查询订单结果
     * @param callback 
     * @param ticketId 
     * @param customizedType
     */
    private getStartOrderStatus(callback: Function, customizedType?: number): void {
        NetManager.ins.getStartStatus(
            callback,
            DataManager.ins.doStartData.ticketId,
            () => { return DataManager.ins.getStartStatusData.code == 0 },
            5,
            customizedType);
    }

    


}