import Panel from "../views/Panel";
import { HtmlTextParser } from "./HtmlTextParser";
import { NetManager } from '../../libs/tw/manager/NetManager';
import { DataManager } from "../../libs/tw/manager/DataManager";
export default class RulePanel extends Panel {
    public labContent: eui.Label;
    public scroller: eui.Scroller;
    start() {
        if (!DataManager.ins.getRuleData)
            NetManager.ins.getRule(() => {
                this.addRule();
            });
        else
            this.addRule();
    }

    group: eui.Group;
    private addRule() {
        let text = DataManager.ins.getRuleData ? DataManager.ins.getRuleData.ruleText : null;
        this.labContent.textFlow = (new HtmlTextParser).parser(text);
    }

     get skinKey() { return 'Rule' }
}
