import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import getOptionImgSize from "./data/getOptionImgSize";
import ImgSizeType from "./data/ImgSizeType";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
import { NetManager } from "../../libs/tw/manager/NetManager";
import showLog from "./ctrl/showLog";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";

export default class PrizePanel extends Panel {

    protected get skinKey() { return 'Prize' }
    
    public closeBtn:eui.Button;
    public useBtn:eui.Button;
    public img:eui.Image;
    public prizeName:eui.Label;
    public dog:eui.Image;
    public scoreTxt:eui.Label;
    public maxScoreTxt:eui.Label;
    
    // 开始
    start(data) {
        // const lottery = DataManager.ins.gameGetSubmitResultData.lottery;
        // this.data = lottery;
        
        // 分数文案
        if(this.scoreTxt){
            this.scoreTxt.text = data.score;
        }
        
        // 最高分文案
        if(this.maxScoreTxt){
            // if(DataManager.ins.getInfoData && DataManager.ins.getInfoData.maxScore){
            //     if(Number(DataManager.ins.getInfoData.maxScore) < data.score){
            //         this.maxScoreTxt.text = `我的最高分：${data.score}分`;;
            //     }else{
            //         this.maxScoreTxt.text = `我的最高分：${DataManager.ins.getInfoData.maxScore}分`;
            //     }
            // }else{
            //     this.maxScoreTxt.visible = false;
            // }
            this.maxScoreTxt.visible = false;
        }
        

        // const sizeType = getOptionImgSize(lottery);
        // if (ImgSizeType.BIG === sizeType) {
        //     this.img.width = this.picBigWidth;
        //     this.img.height = this.picBigWidth / this.bigPicRatio;
        // } else {
        //     this.img.width = this.img.height = this.picWidth;
        // }
        // this.img.y = 480;
        // this.prizeName.y = 480 + 15 + this.img.height; 

        // showLog(lottery);

        // if(lottery.type == 'collectGoods'){
        //     this.useBtn.visible = false;
        // }
    }

    get picWidth() { return 240 };
    get picBigWidth() { return 510 };
    get bigPicRatio() { return 640 / 300 }

    initEvents() {
        super.initEvents();
        this.useBtn.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        // this.img.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_CloseBtn, this)
    }

    private onTap_CloseBtn(e:egret.TouchEvent){
        this.hidePanel();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }

    onUse() {
        this.hidePanel();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        // const lottery = DataManager.ins.gameGetSubmitResultData.lottery;
        // if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
        //     window["downloadAppConfig"] =
        //         {
        //             openUrl: lottery.openUrl,
        //             iosDownloadUrl: lottery.iosDownloadUrl,
        //             androidDownloadUrl: lottery.androidDownloadUrl,
        //             confirm: lottery.confirm ? lottery.confirm : false
        //         };
        //     window["downloadApp"]();
        //     if (lottery.type == "lucky") {
        //         NetManager.ins.spmclick(DataManager.ins.gameGetSubmitResultData.exposure);
        //     }
        // }
        // else {
        //     window.location.href = lottery.link;
        // }
    }


}